%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%% Template      : Ubiquity-KIT.cls
%%%%% Created for   : Ubiquity Press
%%%%% Created by    : diacriTech Technologies
%%%%% Modified on   :
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{Ubiquity-KIT}
              [2016/11/07 v1
 Standard LaTeX document class for Ubiquity Press]
\newcommand\@ptsize{}
\newif\if@restonecol
\newif\if@titlepage
\@titlepagetrue
\newif\if@openright
\newif\if@mainmatter \@mainmattertrue
\if@compatibility\else
\DeclareOption{a4paper}
   {\setlength\paperheight {297mm}%
    \setlength\paperwidth  {210mm}}
\DeclareOption{a5paper}
   {\setlength\paperheight {210mm}%
    \setlength\paperwidth  {148mm}}
\DeclareOption{b5paper}
   {\setlength\paperheight {250mm}%
    \setlength\paperwidth  {176mm}}
\DeclareOption{letterpaper}
   {\setlength\paperheight {11in}%
    \setlength\paperwidth  {8.5in}}
\DeclareOption{legalpaper}
   {\setlength\paperheight {14in}%
    \setlength\paperwidth  {8.5in}}
\DeclareOption{executivepaper}
   {\setlength\paperheight {10.5in}%
    \setlength\paperwidth  {7.25in}}
\DeclareOption{landscape}
   {\setlength\@tempdima   {\paperheight}%
    \setlength\paperheight {\paperwidth}%
    \setlength\paperwidth  {\@tempdima}}
\fi
\if@compatibility
  \renewcommand\@ptsize{0}
\else
\DeclareOption{10pt}{\renewcommand\@ptsize{0}}
\fi
\DeclareOption{11pt}{\renewcommand\@ptsize{1}}
\DeclareOption{12pt}{\renewcommand\@ptsize{2}}
\if@compatibility\else
\DeclareOption{oneside}{\@twosidefalse \@mparswitchfalse}
\fi
\DeclareOption{twoside}{\@twosidetrue  \@mparswitchtrue}
\DeclareOption{draft}{\setlength\overfullrule{5pt}}
\if@compatibility\else
\DeclareOption{final}{\setlength\overfullrule{0pt}}
\fi
\DeclareOption{titlepage}{\@titlepagetrue}
\if@compatibility\else
\DeclareOption{notitlepage}{\@titlepagefalse}
\fi
\if@compatibility
\@openrighttrue
\else
\DeclareOption{openright}{\@openrighttrue}
\DeclareOption{openany}{\@openrightfalse}
\fi
\if@compatibility\else
\DeclareOption{onecolumn}{\@twocolumnfalse}
\fi
\DeclareOption{twocolumn}{\@twocolumntrue}
\DeclareOption{leqno}{\input{leqno.clo}}
\DeclareOption{fleqn}{\input{fleqn.clo}}
\DeclareOption{openbib}{%
  \AtEndOfPackage{%
   \renewcommand\@openbib@code{%
      \advance\leftmargin\bibindent
      \itemindent -\bibindent
      \listparindent \itemindent
      \parsep \z@
      }%
   \renewcommand\newblock{\par}}%
}


\newif\if@prooffile
\@prooffilefalse

\newif\if@printfile
\@printfilefalse

\newif\if@floatasperwidth
\newif\if@endnoteexist \global\@endnoteexistfalse
\newif\if@setdblsapce  \global\@setdblsapcefalse
\newif\if@timesfont \global\@timesfontfalse
\newif\if@palatinofont \global\@palatinofontfalse

%% bibliography
\newif\if@namebib \global\@namebibfalse

\DeclareOption{prooffile}{\@prooffiletrue\AtEndDocument{\clearemptydoublepage}}
\DeclareOption{printfile}{\@printfiletrue\AtEndDocument{\clearemptydoublepage}}
\DeclareOption{floatasperwidth}{\@floatasperwidthtrue}
\DeclareOption{endnotes}{\global\@endnoteexisttrue}
\DeclareOption{dblspace}{\global\@setdblsapcetrue}
\DeclareOption{times}{\global\@timesfonttrue}
\DeclareOption{palatino}{\global\@palatinofonttrue}
\DeclareOption{numbib}{\global\@namebibfalse}
\DeclareOption{namebib}{\global\@namebibtrue}


\ExecuteOptions{a5paper,crop,centre,info,openright}
\ProcessOptions

\newcommand{\clearemptydoublepage}{\newpage{\pagestyle{empty}\cleardoublepage}}

% Not sure if needed.
%\newcommand\@ptsize{0}

% Set twoside printing
\@twosidetrue

% Marginal notes are on the outside edge
\@mparswitchtrue

% Default font sizes
\def\aboveskip{%
\abovedisplayskip=0pt%
\abovedisplayshortskip=0pt%
}%


\renewcommand\normalsize{%
   \@setfontsize\normalsize{10bp}{14bp}%
   \abovedisplayskip 12\p@ \@plus3\p@ \@minus7\p@
   \abovedisplayshortskip \z@ \@plus3\p@
   \belowdisplayshortskip 6.5\p@ \@plus3.5\p@ \@minus3\p@
   \belowdisplayskip \abovedisplayskip
   \let\@listi\@listI}
\normalsize
\let\@bls\baselineskip

\newcommand\small{%
   \@setfontsize\small{9bp}{13bp}
   \abovedisplayskip 11\p@ \@plus3\p@ \@minus6\p@
   \abovedisplayshortskip \z@ \@plus3\p@
   \belowdisplayshortskip 6.5\p@ \@plus3.5\p@ \@minus3\p@
   \def\@listi{\leftmargin\leftmargini
               \topsep 9\p@ \@plus3\p@ \@minus5\p@
               \parsep 4.5\p@ \@plus2\p@ \@minus\p@
               \itemsep \parsep}%
   \belowdisplayskip \abovedisplayskip
}
\newcommand\footnotesize{%
   \@setfontsize\footnotesize{8bp}{11bp}
   \abovedisplayskip 10\p@ \@plus2\p@ \@minus5\p@
   \abovedisplayshortskip \z@ \@plus3\p@
   \belowdisplayshortskip 6\p@ \@plus3\p@ \@minus3\p@
   \def\@listi{\leftmargin\leftmargini
               \topsep 6\p@ \@plus2\p@ \@minus2\p@
               \parsep 3\p@ \@plus2\p@ \@minus\p@
               \itemsep \parsep}%
   \belowdisplayskip \abovedisplayskip
}

\def\@listi{\leftmargin\leftmargini
            \parsep 0\p@% \@plus2\p@ \@minus\p@
            \topsep 6\p@% \@plus2\p@ \@minus4\p@
            \itemsep0\p@% \@plus2\p@ \@minus\p@
            }
\let\@listI\@listi
\@listi
\def\@listii {\leftmargin\leftmarginii
              \labelwidth\leftmarginii
              \advance\labelwidth-\labelsep
              \topsep    4\p@ \@plus2\p@ \@minus\p@
              \parsep    2\p@ \@plus\p@  \@minus\p@
\itemsep   \parsep
}
\def\@listiii{\leftmargin\leftmarginiii
              \labelwidth\leftmarginiii
              \advance\labelwidth-\labelsep
              \topsep    2\p@ \@plus\p@\@minus\p@
              \parsep    \z@
              \partopsep \p@ \@plus\z@ \@minus\p@
              \itemsep   \topsep}
\def\@listiv {\leftmargin\leftmarginiv
              \labelwidth\leftmarginiv
              \advance\labelwidth-\labelsep}
\def\@listv  {\leftmargin\leftmarginv
              \labelwidth\leftmarginv
              \advance\labelwidth-\labelsep}
\def\@listvi {\leftmargin\leftmarginvi
              \labelwidth\leftmarginvi
              \advance\labelwidth-\labelsep}

\newcommand\Huge{\@setfontsize\Huge\@xxvpt{30}}
\newcommand\scriptsize{\@setfontsize\scriptsize\@viiipt{9.5}}
\newcommand\tiny{\@setfontsize\tiny\@vipt\@viipt}
\newcommand\large{\@setfontsize\large\@xivpt{18}}
\newcommand\Large{\@setfontsize\Large\@xviipt{22}}
\newcommand\LARGE{\@setfontsize\LARGE\@xxpt{25}}
\newcommand\huge{\@setfontsize\huge\@xxvpt{30}}


\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalsizes\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\@nomath\sl}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\@nomath\sc}

% Line spacing
\setlength\lineskip{1\p@}
\setlength\normallineskip{1\p@}
%\renewcommand\baselinestretch{}

% Paragraph dimensions and inter-para spacing
\setlength\parskip{10pt}
%\setlength\parindent{24pt}

\setlength\parindent{0pt}


% Set inter-para skips
\setlength\smallskipamount{3\p@ \@plus 1\p@ \@minus 1\p@}
\setlength\medskipamount{6\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\bigskipamount{12\p@ \@plus 4\p@ \@minus 4\p@}



%
% Set page layout dimensions

% Set page layout dimensions
%
\setlength\headheight{11bp}         % height of running head
\setlength\topmargin{33.5bp}          % head margin %%Top of Text
\addtolength{\topmargin}{-1in}

\setlength\topskip{10.5bp}           % height of first line of text
\setlength\headsep{29.8bp}           % space below running head --
\addtolength\headsep{-\topskip}     %   base to base with first line of text

\setlength\textwidth{311.6bp}             % text measure excluding margins
\setlength\textheight{32\@bls} % 32 + 1 = 34 lines
\addtolength\textheight{\topskip}      %    including the first
%\addtolength\textheight{0pt}                                       %    line on the page

\setlength\oddsidemargin   {64bp}
\addtolength{\oddsidemargin}{-1in}

\setlength\evensidemargin  {\paperwidth}
\addtolength\evensidemargin  {-\textwidth}
\addtolength\evensidemargin  {-\oddsidemargin}
\addtolength{\evensidemargin}{-2in}

%\setlength\columnsep{0\p@}          % space between columns for double-column text
%\setlength\columnseprule{0\p@}      % width of rule between two columns


% Footnotes
\setlength\footnotesep{6.5\p@}     % space between footnotes
% space between text and footnote
\setlength{\skip\footins}{12\p@}%
\addtolength{\footskip}{37.5pt}

% Float placement parameters

% The total number of floats that can be allowed on a page.
\setcounter{totalnumber}{10}
% The maximum number of floats at the top and bottom of a page.
\setcounter{topnumber}{5}
\setcounter{bottomnumber}{5}
% The maximum part of the top or bottom of a text page that can be
% occupied by floats. This is set so that at least four lines of text
% fit on the page.
\renewcommand\topfraction{.921}
\renewcommand\bottomfraction{.921}
% The minimum amount of a text page that must be occupied by text.
% This should accomodate four lines of text.
\renewcommand\textfraction{.079}
% The minimum amount of a float page that must be occupied by floats.
\renewcommand\floatpagefraction{.887}

% The same parameters repeated for double column output
\renewcommand\dbltopfraction{.88}
\renewcommand\dblfloatpagefraction{.88}

% Space between floats
\setlength\floatsep    {12\p@ \@plus 2\p@ \@minus 2\p@}
% Space between floats and text
\setlength\textfloatsep{20\p@ \@plus 2\p@ \@minus 4\p@}
% Space above and below an inline figure
\setlength\intextsep   {18\p@ \@plus 2\p@ \@minus 2\p@}

% For double column floats
\setlength\dblfloatsep    {12\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\dbltextfloatsep{20\p@ \@plus 2\p@ \@minus 4\p@}

% Space left at top, bottom and inbetween floats on a float page.
\setlength\@fptop{0\p@}         % no space above float page figures
\setlength\@fpsep{12\p@ \@plus 2fil}
\setlength\@fpbot{0\p@ \@plus 1fil}

% The same for double column
\setlength\@dblfptop{0\p@}
\setlength\@dblfpsep{12\p@ \@plus 1fil}
\setlength\@dblfpbot{0\p@ \@plus 2fil}

%%%% layout
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\def\trimwidth#1{\gdef\@trimwidth{#1}}
\def\trimheight#1{\gdef\@trimheight{#1}}

% Load all necessary packages
\def\fullpaperwidth#1{\gdef\@fullpaperwidth{#1}}
\def\fullpaperheight#1{\gdef\@fullpaperheight{#1}}

% Paperwidth and paperheight with 1in margin

\fullpaperwidth{6.82truein}
\fullpaperheight{9.26truein}

% Extract Paperwidth and paperheight

\trimwidth{5.82in}
\trimheight{8.26in}

\setlength{\paperwidth}{\@trimwidth}%8.5in
\setlength{\paperheight}{\@trimheight}%10.875in

\newif\if@printfile@provided \@printfile@providedfalse
\newcommand{\printfiles}{%
\usepackage[cam,a5paper]{../Styles/up-pcrop}
%\voffset=36pt
%\hoffset=36pt
\global\@printfile@providedtrue\pdfminorversion=3
}

\newif\if@prooffile@provided \@prooffile@providedfalse
\newcommand{\prooffiles}{%
\usepackage[cam,a5papernew]{../Styles/up-crop}
\voffset=36pt
\hoffset=36pt
\global\@prooffile@providedtrue\pdfminorversion=3%
}


\newbox\abstracttextbox%

\newenvironment{abstract}[1][]{%%
\global\setbox\abstracttextbox\vbox\bgroup\parindent=0pt\topsep0pt\nointerlineskip\vskip020pt\nointerlineskip%
\ignorespaces{{\bfseries\fontsize{14bp}{16bp}\selectfont#1}}\par\addvspace{-1pt}}{\egroup}%

\gdef\printabstract{%
    {\large \unvbox\abstracttextbox}%
\par\nointerlineskip\addvspace{8pt}\ignorespaces\nointerlineskip}%

\gdef\printkeywords{%
    {\large \unvbox\keywords}%
\par\nointerlineskip\addvspace{10pt}\ignorespaces\nointerlineskip}%

\long\def\corresp#1{\gdef\@corresp{{\noindent\fontsize{8bp}{10bp}\selectfont#1}}}\gdef\@corresp{}%


\newbox\keywordsbox%
\newbox\keywords
\newenvironment{keyword}[1][]{%
\global\setbox\keywords\vbox\bgroup\nointerlineskip\nointerlineskip\parindent=0pt\vskip3pt\nointerlineskip%
\ignorespaces\textbf{#1}
\raggedright}{\egroup}%

\gdef\printcorres{%
    {\unvbox\corresbox}%
\par\nointerlineskip\ignorespaces\nointerlineskip}%


\def\affiliation#1{\gdef\@affiliation{#1}}\gdef\@affiliation{}

\def\articletype#1{\gdef\@articletype{{\raggedright\bfseries\MakeUppercase{#1}}}}\gdef\@articletype{}%

\def\subtitle#1{\gdef\@subtitle{#1}}\gdef\@subtitle{}%


\def\received#1{\gdef\@received{#1}}\gdef\@received{}%
\def\revised#1{\gdef\@revised{Revised #1}}\gdef\@revised{}%
\def\accepted#1{\gdef\@accepted{#1}}\gdef\@accepted{}%
\def\published#1{\gdef\@published{#1}}\gdef\@published{}%
\def\submitted#1{\gdef\@submitted{#1}}\gdef\@submitted{}%

\setlength\lineskip{1\p@}
\setlength\normallineskip{1\p@}
\renewcommand\baselinestretch{}
%\setlength\parskip{0\p@ \@plus \p@}
\@lowpenalty   51
\@medpenalty  151
\@highpenalty 301
\setcounter{topnumber}{2}
\renewcommand\topfraction{.7}
\setcounter{bottomnumber}{1}
\renewcommand\bottomfraction{.3}
\setcounter{totalnumber}{3}
\renewcommand\textfraction{.2}
\renewcommand\floatpagefraction{.5}
\setcounter{dbltopnumber}{2}
\renewcommand\dbltopfraction{.7}
\renewcommand\dblfloatpagefraction{.5}
\if@twoside
  \def\ps@headings{%
      \let\@oddfoot\@empty\let\@evenfoot\@empty
      \def\@evenhead{\thepage\hfil\slshape\leftmark}%
      \def\@oddhead{{\slshape\rightmark}\hfil\thepage}%
      \let\@mkboth\markboth
    \def\chaptermark##1{%
      \markboth {\MakeUppercase{%
        \ifnum \c@secnumdepth >\m@ne
          \if@mainmatter
            \@chapapp\ \thechapter. \ %
          \fi
        \fi
        ##1}}{}}%
    \def\sectionmark##1{%
      \markright {\MakeUppercase{%
        \ifnum \c@secnumdepth >\z@
          \thesection. \ %
        \fi
        ##1}}}}
\else
  \def\ps@headings{%
    \let\@oddfoot\@empty
    \def\@oddhead{{\slshape\rightmark}\hfil\thepage}%
    \let\@mkboth\markboth
    \def\chaptermark##1{%
      \markright {\MakeUppercase{%
        \ifnum \c@secnumdepth >\m@ne
          \if@mainmatter
            \@chapapp\ \thechapter. \ %
          \fi
        \fi
        ##1}}}}
\fi
\def\ps@myheadings{%
    \let\@oddfoot\@empty\let\@evenfoot\@empty
    \def\@evenhead{\thepage\hfil\slshape\leftmark}%
    \def\@oddhead{{\slshape\rightmark}\hfil\thepage}%
    \let\@mkboth\@gobbletwo
    \let\chaptermark\@gobble
    \let\sectionmark\@gobble
    }

\def\rectohead#1{\gdef\@rectohead{#1}}\gdef\@rectohead{}



%\def\arttitle#1{\gdef\@arttitle{#1}}\gdef\@arttitle{}
\newcommand{\arttitlefont}{\bfseries\fontsize{20bp}{24bp}\selectfont\raggedright}
 \if@titlepage
  \newcommand\maketitle{\begin{titlepage}\thispagestyle{plainch}%
  \let\footnotesize\small
  %\let\footnoterule\relax
  \let \footnote \thanks
  %\null\vfil
  \vspace*{-6pt}
  %\begin{center}%
  \ifx\@articletype\empty\else{\@articletype\par}\fi%
    {\arttitlefont{\@title\par}\addcontentsline{toc}{chapter}{\@title}\addvspace{9pt}
}\rectohead{\@title}%
    \ifx\@subtitle\empty\else{\@subtitle \par}\fi%
    {
    \begin{tabular}[t]{@{}l}%
       {\itshape \@author\addcontentsline{toc}{author}{\@author}}
      \end{tabular}\par\addvspace{-6pt}}%
 {\ifx\@affiliation\empty\else{\fontsize{8bp}{10bp}\itshape\selectfont\@affiliation}\fi}
      \vskip3pt%
  %  {\@date \par}%       % Set date in \large size.
\printabstract\par
\printkeywords\par
\ifx\@corresp\empty\else\@corresp\fi\par
{\normalfont\fontsize{9bp}{11bp}\selectfont\par\addvspace{10pt}%
\noindent\ifx\@submitted\empty\else\textbf{Submitted:}\@submitted\space\fi%
         \ifx\@revised\empty\else\textbf{Revised:}\@revised\space\fi%
         \ifx\@accepted\empty\else\textbf{Accepted:}\@accepted\space\fi%
         \ifx\@published\empty\else\textbf{Published:}\@published\fi%
\par\addvspace{1pt}}%
  %\end{center}
  \par
  \@thanks
  %\vfil\null
  \end{titlepage}%
  \setcounter{footnote}{0}%
  \global\let\thanks\relax
  \global\let\maketitle\relax
  \global\let\@thanks\@empty
  \global\let\@author\@empty
  \global\let\@date\@empty
  \global\let\@title\@empty
  \global\let\title\relax
  \global\let\author\relax
  \global\let\date\relax
  \global\let\and\relax
}
\else
\newcommand\maketitle{\par
  \begingroup
    \renewcommand\thefootnote{\@fnsymbol\c@footnote}%
    \def\@makefnmark{\rlap{\@textsuperscript{\normalfont\@thefnmark}}}%
    \long\def\@makefntext##1{\parindent 1em\noindent
            \hb@xt@1.8em{%
                \hss\@textsuperscript{\normalfont\@thefnmark}}##1}%
    \if@twocolumn
      \ifnum \col@number=\@ne
        \@maketitle
      \else
        \twocolumn[\@maketitle]%
      \fi
    \else
      \newpage
      \global\@topnum\z@   % Prevents figures from going at top of page.
      \@maketitle
    \fi
    \thispagestyle{plain}\@thanks
  \endgroup
  \setcounter{footnote}{0}%
  \global\let\thanks\relax
  \global\let\maketitle\relax
  \global\let\@maketitle\relax
  \global\let\@thanks\@empty
  \global\let\@author\@empty
  \global\let\@date\@empty
  \global\let\@title\@empty
  \global\let\title\relax
  \global\let\author\relax
  \global\let\date\relax
  \global\let\and\relax
}


\def\@maketitle{%
  \newpage
  \null
  \vskip 2em%
  \begin{center}%
  \let \footnote \thanks
    {\LARGE \@title \par}%
    \vskip 1.5em%
    {\large
      \lineskip .5em%
      \begin{tabular}[t]{c}%
        \@author\\[4pc]
        \ifx\@address\@empty\else\@address\fi\\
      \end{tabular}\par}%
    \vskip 1em%
    {\large \@date}%
  \end{center}%
  \par
  \vskip 1.5em}
\fi
\newcommand*\chaptermark[1]{}
\newcounter {part}
\newcounter {subpart}
\newcounter {chapter}
\newcounter {section}[chapter]
\newcounter {subsection}[section]
\newcounter {subsubsection}[subsection]
\newcounter {paragraph}[subsubsection]
\newcounter {subparagraph}[paragraph]
\renewcommand \thepart {\@Roman\c@part}
\renewcommand \thesubpart {\@Roman\c@subpart}
\renewcommand \thechapter {\@arabic\c@chapter}
\renewcommand \thesection {\@arabic\c@section}
\renewcommand\thesubsection   {\thesection.\@arabic\c@subsection}
\renewcommand\thesubsubsection{\thesubsection.\@arabic\c@subsubsection}
\renewcommand\theparagraph    {\thesubsubsection.\@arabic\c@paragraph}
\renewcommand\thesubparagraph {\theparagraph.\@arabic\c@subparagraph}
\newcommand\@chapapp{\chaptername}
\newcommand\frontmatter{%
    \cleardoublepage
  \@mainmatterfalse
  \pagenumbering{roman}}
\newcommand\mainmatter{%
    \cleardoublepage
  \@mainmattertrue
  \pagenumbering{arabic}}
\newcommand\backmatter{%
  \if@openright
    \cleardoublepage
  \else
    \clearpage
  \fi
  \@mainmatterfalse}
\newcommand\part{%
  \if@openright
    \cleardoublepage
  \else
    \clearpage
  \fi
  \thispagestyle{plain}%
  \if@twocolumn
    \onecolumn
    \@tempswatrue
  \else
    \@tempswafalse
  \fi
  \null\vfil
  \secdef\@part\@spart}

\def\@part[#1]#2{%
    \ifnum \c@secnumdepth >-2\relax
      \refstepcounter{part}%
      \addcontentsline{toc}{part}{\thepart\hspace{1em}#1}%
    \else
      \addcontentsline{toc}{part}{#1}%
    \fi
    \markboth{}{}%
    {\centering
     \interlinepenalty \@M
     \normalfont
     \ifnum \c@secnumdepth >-2\relax
       \huge\bfseries \partname\nobreakspace\thepart
       \par
       \vskip 20\p@
     \fi
     \Huge \bfseries #2\par}%
    \@endpart}
\def\@spart#1{%
    {\centering
     \interlinepenalty \@M
     \normalfont
     \Huge \bfseries #1\par}%
    \@endpart}
\def\@endpart{\vfil\newpage
              \if@twoside
               \if@openright
                \null
                \thispagestyle{empty}%
                \newpage
               \fi
              \fi
              \if@tempswa
                \twocolumn
              \fi}
\newcommand\chapter{\if@openright\clearemptydoublepage\else\clearpage\fi
                    \thispagestyle{plain}%
                    \global\@topnum\z@
%                    \@afterindentfalse
                    \@afterindenttrue
                    \secdef\@chapter\@schapter}
\def\@chapter[#1]#2{\ifnum \c@secnumdepth >\m@ne
                       \if@mainmatter
                         \refstepcounter{chapter}%
                         \typeout{\@chapapp\space\thechapter.}%
                         \addcontentsline{toc}{chapter}%
                                   {\protect\numberline{\thechapter:}#1}%
                       \else
                         \setcounter{part}{1}
                         \addcontentsline{toc}{bmchapter}{\protect\numberline{\@chapapps\space\Alphee{part}:}#1}%
                       \fi
                    \else
                      \addcontentsline{toc}{chapter}{\protect\numberline{\thechapter:}#1}%
                    \fi
                    \chaptermark{#1}%
                    \addtocontents{lof}{\protect\addvspace{10\p@}}%
                    \addtocontents{lot}{\protect\addvspace{10\p@}}%
                    \if@twocolumn
                      \@topnewpage[\@makechapterhead{#2}]%
                    \else
                      \@makechapterhead{#2}%
                      \@afterheading
                    \fi}

\def\@schapter#1{\if@twocolumn
                   \@topnewpage[\@makeschapterhead{#1}]%
                 \else
                   \@makeschapterhead{#1}%
                   \@afterheading
                 \fi}
\def\@makeschapterhead#1{%
  \vspace*{-25.5\p@}%
  {\parindent \z@ %\centering%\raggedright
    \normalfont
    \interlinepenalty\@M
    {\bfseries\fontsize{20bp}{24bp}\selectfont#1}\par\nobreak
    \vskip 14\p@
    %\addcontentsline{toc}{fmchapter}{#1}
  }\enlargethispage{-12pt}}

\def\@ssect#1#2#3#4#5{%
  \@tempskipa #3\relax
  \ifdim \@tempskipa>\z@
\@afterindentfalse
    \begingroup
      #4{%
        \@hangfrom{\hskip #1}%
          \interlinepenalty \@M #5\@@par\@afterindentfalse}%
    \endgroup
  \else
    \def\@svsechd{#4{\hskip #1\relax #5\@afterindentfalse}}%
  \fi
  \@xsect{#3}}

\newcommand\section{\@startsection {section}{1}{\z@}%
                                   {12pt plus6pt minus3pt}%
                                   {1pt}%
                                   {\normalfont\fontsize{14bp}{16bp}\bfseries\raggedright\selectfont}}

\newcommand\exercises{\@startsection {section}{1}{\z@}%
                                   {12pt plus6pt minus3pt}%
                                   {1pt}%
                                   {\normalfont\sffamily\fontsize{12bp}{14bp}\bfseries\raggedright\selectfont\MakeUppercase}}


\newcommand\subsection{\@startsection{subsection}{2}{\z@}%
                                     {6pt}%
                                     {1pt}%
                                     {\normalfont\fontsize{12bp}{14bp}\selectfont\bfseries}}
\newcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
                                     {-3.25ex\@plus -1ex \@minus -.2ex}%
                                     {1pt}%
                                     {\normalfont\normalsize\bfseries}}
\newcommand\paragraph{\@startsection{paragraph}{4}{0pt}%
                                    {4.5pt}%
                                    {-5pt}%
                                    {\normalfont\normalsize\bfseries}}
\newcommand\subparagraph{\@startsection{subparagraph}{5}{0pt}%
                                       {4.5pt}%
                                       {-5pt}%
                                       {\normalfont\normalsize\bfseries\itshape}}


\if@twocolumn
  \setlength\leftmargini  {17.5pt}
\else
  \setlength\leftmargini  {17.5pt}
\fi
\leftmargin  \leftmargini
\setlength\leftmarginii  {17.5pt}
\setlength\leftmarginiii {17.5pt}
\setlength\leftmarginiv  {17.5pt}
\if@twocolumn
  \setlength\leftmarginv  {.5em}
  \setlength\leftmarginvi {.5em}
\else
  \setlength\leftmarginv  {1em}
  \setlength\leftmarginvi {1em}
\fi
\setlength  \labelsep  {.5em}
\setlength  \labelwidth{\leftmargini}
\addtolength\labelwidth{-\labelsep}
\@beginparpenalty -\@lowpenalty
\@endparpenalty   -\@lowpenalty
\@itempenalty     -\@lowpenalty
\renewcommand\theenumi{\@arabic\c@enumi}
\renewcommand\theenumii{\@alph\c@enumii}
\renewcommand\theenumiii{\@roman\c@enumiii}
\renewcommand\theenumiv{\@Alph\c@enumiv}
\newcommand\labelenumi{\theenumi.}
\newcommand\labelenumii{\theenumii.}
\newcommand\labelenumiii{\theenumiii.}
\newcommand\labelenumiv{\theenumiv.}
\renewcommand\p@enumii{\theenumi}
\renewcommand\p@enumiii{\theenumi(\theenumii)}
\renewcommand\p@enumiv{\p@enumiii\theenumiii}
%\newcommand\labelitemi{\textbullet}

\font\itembull=MTSY at 10pt
\def\labelitemi{\itembull\raisebox{1pt}{\char'017}}
\newcommand\labelitemii{\itembull\raisebox{1pt}{\char'017}}
\newcommand\labelitemiii{\itembull\raisebox{1pt}{\char'017}}
\newcommand\labelitemiv{\textperiodcentered}
\newenvironment{description}
               {\list{}{\labelwidth\z@ \itemindent-\leftmargin
                        \let\makelabel\descriptionlabel}}
               {\endlist}
\newcommand*\descriptionlabel[1]{\hspace\labelsep
                                \normalfont\bfseries #1}


\newenvironment{descriptionlist}[1][72pt]
               {\list{}{\settowidth{\labelwidth}{#1}%
                        \labelsep=12pt%
                        \leftmargin\labelwidth%
                        \advance\leftmargin\labelsep%
                        \def\makelabel##1{\hss\llap{\null\hfill\itshape##1:}}
                        }}
               {\endlist}


\newenvironment{verse}
               {\let\\\@centercr
                \list{}{\itemsep      \z@
                        \itemindent   -1.5em%
                        \listparindent\itemindent
                        \rightmargin  \leftmargin
                        \advance\leftmargin 1.5em}%
                \item\relax}
               {\endlist}
\newenvironment{quotation}
               {\list{}{\listparindent 1.5em%
                        \itemindent    \listparindent
                        \rightmargin   \leftmargin
                        \parsep        \z@ \@plus\p@}%
                \item\relax}
               {\endlist}
\def\QuoteSoure#1{\begingroup\hbox to
\textwidth{\hfill\fontsize{10}{12}\selectfont#1\hspace*{180pt}}\endgroup}
\newenvironment{quote}
               {\vspace*{0pt}\list{}{\rightmargin=2pc\leftmargin=2pc}%
                \fontsize{10bp}{12bp}\itshape\selectfont\item\relax}
               {\endlist\vspace*{0pt}}
\if@compatibility
\newenvironment{titlepage}
    {%
      \cleardoublepage
      \if@twocolumn
        \@restonecoltrue\onecolumn
      \else
        \@restonecolfalse\newpage
      \fi
      \thispagestyle{empty}%
      %\setcounter{page}\z@
    }%
    {\if@restonecol\twocolumn \else \newpage \fi
    }
\else
\newenvironment{titlepage}
    {%
      \cleardoublepage
      \if@twocolumn
        \@restonecoltrue\onecolumn
      \else
        \@restonecolfalse\newpage
      \fi
      \thispagestyle{empty}%
      %\setcounter{page}\@ne
    }%
    {\if@restonecol\twocolumn \else \newpage \fi
     \if@twoside\else
        %\setcounter{page}\@ne
     \fi
    }
\fi


\def\@makeappchapterhead#1{\setcounter{part}{1}%
  \vspace*{9pt}%
  {%\parindent 0pt% \raggedright
  \normalfont
    \ifnum \c@secnumdepth >\m@ne
      \if@mainmatter
      \fi
    \fi
    \interlinepenalty\@M
       \thispagestyle{plain}\centerline{\fontsize{12}{14}\fontfamily{\rmdefault}\selectfont Appendix \space \Alphee{part}}
    \fontsize{18}{20}\selectfont\centering #1\vphantom{g}\par\nobreak
    \vskip 169.2pt
  }
}

\newcommand\appendix{\par
\addtocontents{toc}{\protect\vskip.9pc}%
  \setcounter{chapter}{0}%
  \setcounter{section}{0}%
  \gdef\@chapapps{\appendixname}%
  \gdef\thechapter{\@Alph\c@chapter}
  \setcounter{equation}{0}
  \renewcommand\theequation
  {\ifnum \c@chapter>\z@ \Alph{chapter}.\fi \arabic{equation}}
  \let\@makechapterhead\@makeappchapterhead
}


\setlength\arraycolsep{5\p@}
\setlength\tabcolsep{6\p@}
\setlength\arrayrulewidth{.5\p@}
\setlength\doublerulesep{2\p@}

\renewcommand\arraystretch{2}
\setlength\tabbingsep{\labelsep}
\skip\@mpfootins = \skip\footins
\setlength\fboxsep{3\p@}
\setlength\fboxrule{.4\p@}
\@addtoreset {equation}{chapter}
\renewcommand\theequation
  {\ifnum \c@chapter>\z@ \thechapter.\fi \@arabic\c@equation}
\newcounter{figure}[chapter]
\renewcommand \thefigure
     {\ifnum \c@chapter>\z@ \thechapter.\fi \@arabic\c@figure}
\def\fps@figure{tbp}
\def\ftype@figure{1}
\def\ext@figure{lof}
\def\fnum@figure{\figurename\nobreakspace\thefigure}
\newenvironment{figure}
               {\@float{figure}}
               {\end@float}
\newenvironment{figure*}
               {\@dblfloat{figure}}
               {\end@dblfloat}
\newcounter{table}[chapter]
\renewcommand \thetable
     {\ifnum \c@chapter>\z@ \thechapter.\fi \@arabic\c@table}
\def\fps@table{tbp}
\def\ftype@table{2}
\def\ext@table{lot}
\def\fnum@table{\tablename\nobreakspace\thetable}
\newenvironment{table}
               {\let\@makecaption\@tablecaption
               \@float{table}}
               {\end@float}
\newenvironment{table*}
               {\let\@makecaption\@tablecaption\@dblfloat{table}}
               {\end@dblfloat}
\newlength\abovecaptionskip
\newlength\belowcaptionskip
\setlength\abovecaptionskip{10\p@}
\setlength\belowcaptionskip{0\p@}
\long\def\@makecaption#1#2{%
  \vskip\abovecaptionskip
  \sbox\@tempboxa{: #2}%
  \ifdim \wd\@tempboxa >\hsize
    #1: #2\par
  \else
    \global \@minipagefalse
    \hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip}

\long\def\@maketablecaption#1#2{%
%  \vskip\abovecaptionskip
  \sbox\@tempboxa{#1: #2}%
  \ifdim \wd\@tempboxa >\hsize
    #1: #2\par
  \else
    \global \@minipagefalse
    \hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip}

\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\@nomath\sl}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\@nomath\sc}
\DeclareRobustCommand*\cal{\@fontswitch\relax\mathcal}
\DeclareRobustCommand*\mit{\@fontswitch\relax\mathnormal}
\newcommand\@pnumwidth{1.55em}
\newcommand\@tocrmarg{2.55em}
\newcommand\@dotsep{1}
\setcounter{tocdepth}{1}


\newcommand\tableofcontents{\if@openright\clearemptydoublepage\else\clearpage\fi%
\def\contentsname{Inhaltsverzeichnis}
    \if@twocolumn
      \@restonecoltrue\onecolumn
    \else
      \@restonecolfalse
    \fi
%\vspace*{34pt}%
  {\parindent \z@ %\centering%\raggedright
    \normalfont
    \interlinepenalty\@M
   \thispagestyle{empty} \chapter*{\contentsname}\par\nobreak
    %\vskip 169.2pt
  }  \@afterindentfalse
  \@afterheading
      \@mkboth{\contentsname}%
              {\contentsname}%
    \@starttoc{toc}%
    \if@restonecol\twocolumn\fi
    %\addcontentsline{toc}{fmchapter}{\contentsname}
    }
\newcommand*\l@part[2]{%
  \ifnum \c@tocdepth >-2\relax
    \addpenalty{-\@highpenalty}%
    \addvspace{2.25em \@plus\p@}%
    \setlength\@tempdima{3em}%
    \begingroup
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      {\leavevmode
       \large \bfseries #1\hfil \hb@xt@\@pnumwidth{\hss #2}}\par
       \nobreak
         \global\@nobreaktrue
         \everypar{\global\@nobreakfalse\everypar{}}%
    \endgroup
  \fi}
\newcommand*\l@chapter[2]{%
  \ifnum \c@tocdepth >\m@ne
    \addpenalty{-\@highpenalty}%
    \vskip 1.0em %\@plus\p@
    \setlength\@tempdima{1.5em}%
    \begingroup
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      \leavevmode \bfseries
      \advance\leftskip\@tempdima
      \hskip -\leftskip
     Chapter #1\nobreak\leaders\hbox{$\m@th \mkern \@dotsep mu\hbox{.}\mkern \@dotsep
        mu$}\hfill \nobreak\hb@xt@\@pnumwidth{\hss\bfseries#2}\par
      \penalty\@highpenalty
    \endgroup
  \fi}

\newcommand*\l@author[2]{
\ifnum \c@tocdepth >\m@ne
    \addpenalty{-\@highpenalty}%
    \vskip 1.0em %\@plus\p@
    \setlength\@tempdima{1.5em}%
    \begingroup
      \parindent \z@ \rightskip \@pnumwidth
      %\parfillskip -\@pnumwidth
      \leavevmode %\bfseries
      \advance\leftskip\@tempdima
      \hskip -\leftskip
   {\fontsize{8bp}{12bp}\selectfont  #1}\par\vspace*{-13pt}
    \endgroup
  \fi}


%\ifnum \c@tocdepth >\m@ne
%    \addpenalty{-\@highpenalty}%
%%    \vskip 1.0em \@plus\p@
%    \setlength\@tempdima{1.5em}%
%    \begingroup
%      \parindent \z@ %\rightskip \@pnumwidth
%      \rightskip \@tocrmarg plus1fill
%%      \parfillskip -\@pnumwidth
%      \leavevmode \itshape
%      %\advance\leftskip\@tempdima
%      \hskip -\leftskip
%\advance\leftskip by 17bp%
%%\hangindent-10pt
%      #1\nobreak\par
%      \penalty\@highpenalty
%    \endgroup
%  \fi


  \newcommand*\l@spchapter[2]{%
  \ifnum \c@tocdepth >\m@ne
    \addpenalty{-\@highpenalty}%
    \vskip 1.0em %\@plus\p@
    \setlength\@tempdima{1.5em}%
    \begingroup
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      \leavevmode \bfseries
      \advance\leftskip\@tempdima
      \hskip -\leftskip
     \hspace*{-14pt}#1\nobreak\leaders\hbox{$\m@th \mkern \@dotsep mu\hbox{.}\mkern \@dotsep
        mu$} \hb@xt@\@pnumwidth{#2}\par
      \penalty\@highpenalty
    \endgroup
  \fi}


\newcommand*\l@fmchapter[2]{%
  \ifnum \c@tocdepth >\m@ne
    \addpenalty{-\@highpenalty}%
    \vskip 1.0em %\@plus\p@
    \setlength\@tempdima{1.5em}%
    \begingroup
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      \leavevmode \bfseries
      \advance\leftskip\@tempdima
      \hskip -\leftskip
     \bfseries#1\nobreak\leaders\hbox{$\m@th \mkern \@dotsep mu\hbox{.}\mkern \@dotsep
        mu$}\hfill \nobreak\hb@xt@\@pnumwidth{\hss #2}\par
      \penalty\@highpenalty
    \endgroup
  \fi}

\def\toctitle#1#2{\thispagestyle{empty}\contentsline {chaptertitle}{\numberline {}#1}{#2}}

\def\tocauthor#1#2{\contentsline {chapterauthor}{\numberline {}#1}{}}


\newcommand*\l@section{\@dottedtocline{1}{1.5em}{2.3em}}
\newcommand*\l@subsection{\@dottedtocline{2}{2.8em}{3.2em}}
\newcommand*\l@subsubsection{\@dottedtocline{3}{6.0em}{4.1em}}
\newcommand*\l@paragraph{\@dottedtocline{4}{10em}{5em}}
\newcommand*\l@subparagraph{\@dottedtocline{5}{12em}{6em}}
\newcommand\listoffigures{%
    \if@twocolumn
      \@restonecoltrue\onecolumn
    \else
      \@restonecolfalse
    \fi
    \chapter*{\listfigurename}%
      \@mkboth{\listfigurename}%
              {\listfigurename}%
    \@starttoc{lof}%
    \if@restonecol\twocolumn\fi
    }
\newcommand*\l@figure{\@dottedtocline{1}{1.5em}{2.3em}}
\newcommand\listoftables{%
    \if@twocolumn
      \@restonecoltrue\onecolumn
    \else
      \@restonecolfalse
    \fi
    \chapter*{\listtablename}%
      \@mkboth{%
          \listtablename}%
         {\listtablename}%
    \@starttoc{lot}%
    \if@restonecol\twocolumn\fi
    }

\let\l@table\l@figure
\newdimen\bibindent
\setlength\bibindent{1.5em}

\newenvironment{thebibliography}[1]
     {\section*{References}%
%      \@mkboth{REFERENCES}{REFERENCES}%
      \list{}%\@arabic\c@enumiv
           {\settowidth\labelwidth{\@biblabel{#1}}%
            \leftmargin\labelwidth
            \advance\leftmargin-6pt\itemsep3pt
            \@openbib@code
            \usecounter{enumiv}%
            \let\p@enumiv\@empty
            \renewcommand\theenumiv{\@arabic\c@enumiv}}%
      \sloppy
      \clubpenalty4000
      \@clubpenalty \clubpenalty
      \widowpenalty4000%
      \sfcode`\.\@m}
     {\def\@noitemerr
       {\@latex@warning{Empty `thebibliography' environment}}%
      \endlist}

\newcommand\newblock{\hskip .11em\@plus.33em\@minus.07em}
\let\@openbib@code\@empty

\newenvironment{theindex}
               {\if@twocolumn
                  \@restonecolfalse
                \else
                  \@restonecoltrue
                \fi
                \twocolumn[\vspace*{19pt}\@makeschapterhead{\indexname}]%
                \@mkboth{\MakeUppercase\indexname}%
                        {\MakeUppercase\indexname}%
                \thispagestyle{plain}\parindent\z@
                \parskip\z@ \@plus .3\p@\relax
                \columnseprule \z@
                \columnsep 35\p@
                \let\item\@idxitem}
               {\if@restonecol\onecolumn\else\clearpage\fi}
\newcommand\indexhead[1]{\par\addvspace{1pc}\noindent\textbf{#1}\par\addvspace{6pt}}
\newcommand\@idxitem{\par\hangindent 40\p@}
\newcommand\subitem{\@idxitem \hspace*{10\p@}}
\newcommand\subsubitem{\@idxitem \hspace*{20\p@}}
\newcommand\indexspace{\par \vskip 10\p@ \@plus5\p@ \@minus3\p@\relax}

\renewcommand\footnoterule{%
  \kern-3\p@
  \hrule\@width.4\columnwidth
  \kern2.6\p@}
  \newcommand\footnoteruled{%
  \kern-3\p@
  \hrule\@width0\columnwidth
  \kern2.6\p@}

 \def\creditline{\let\footnoterule\footnoteruled\@ifnextchar [{\@xfootnotenextt}%
   {\begingroup\let\protect\noexpand
      %\xdef\@thefnmark{\thempfn}
      \endgroup
    \@footnotetextt}}

\def\@xfootnotenextt[#1]{\begingroup %\csname c@\@mpfn\endcsname #1\relax
   \let\protect\noexpand
   %\xdef\@thefnmark{\thempfn}
   \endgroup \@footnotetextt}

\long\def\@footnotetextt#1{\insert\footins{\reset@font\footnotesize
    \interlinepenalty\interfootnotelinepenalty
    \splittopskip\footnotesep
    \splitmaxdepth \dp\strutbox \floatingpenalty \@MM
    \hsize\columnwidth \@parboxrestore
%   \edef\@currentlabel{\csname p@footnote\endcsname\@thefnmark}\@makefntext
    {\rule{\z@}{\footnotesep}\ignorespaces
      #1\strut}}}

\@addtoreset{footnote}{chapter}

%\newcommand\@makefntext[1]{%
%    \parindent 1em%
%    \noindent
%    \hb@xt@1.8em{\hss\@makefnmark}#1}

\AtBeginDocument{
\renewcommand\footnoterule{%
  \kern-3\p@
  \hrule\@width50pt
  \kern2.6\p@}

\renewcommand\@makefntext[1]{%\leftskip9pt%
\reset@font\fontsize{8bp}{11bp}\selectfont\raggedright%
\parindent=0pt%
\noindent%
\@hangfrom{\hbox to 9.5pt{\textsuperscript{\@thefnmark}}\hskip2.5pt}#1}

\renewcommand{\thefootnote}{\arabic{footnote}}
    }


\newcommand\contentsname{Inhaltsverzeichnis}
\newcommand\listfigurename{List of Figures}
\newcommand\listtablename{List of Tables}
\newcommand\bibname{Bibliography}
\newcommand\indexname{Index}
\newcommand\figurename{FIGURE}
\newcommand\tablename{Tabelle}
\newcommand\partname{Part}
\newcommand\subpartname{SubPart}
\newcommand\chaptername{C\hspace*{2.6pt}H\hspace*{2.6pt}A\hspace*{2.6pt}P\hspace*{2.6pt}T\hspace*{2.6pt}E\hspace*{2.6pt}R}
\newcommand\appendixname{Appendix}
\def\today{\ifcase\month\or
  January\or February\or March\or April\or May\or June\or
  July\or August\or September\or October\or November\or December\fi
  \space\number\day, \number\year}
\setlength\columnsep{10\p@}
\setlength\columnseprule{0\p@}

\def\booktitle#1{\gdef\@booktitle{#1}}
\booktitle{The Multi-Agent Transport Simulation MATSim}

\def\runinheads#1#2{\markboth{#1}{#2}}

%\def\ps@headings{%
%      \let\@oddfoot\@empty\let\@evenfoot\@empty
%      \def\@evenhead{\fontsize{9}{11}\fontfamily{\rmdefault}\selectfont{{\thepage}}\hspace*{9.7pt}\rightmark\hfil}%
%      \def\@oddhead{\hfill\fontsize{9}{11}\fontfamily{\rmdefault}\selectfont{\leftmark}\hspace*{9.7pt}{{\thepage}}}%
%      \let\@mkboth\markboth
%    \def\chaptermark##1{%
%      \markboth{\ifnum \c@secnumdepth >\m@ne
%          \if@mainmatter
%          %{%
%          %{\@chapapp\ \thechapter aaa}
%          %}%\hspace*{1em}%
%          \fi
%        \fi
%        ##1}{##1}}%
%    \def\sectionmark##1{%
%     {%\MakeUppercase
%    {%
%        \ifnum \c@secnumdepth >\z@
%          %{\thesection}\hspace*{6pt}%
%        \fi
%        %##1
%        }}}}

\def\jtitle#1{\gdef\@jtitle{#1}}\gdef\@jtitle{}

\jtitle{Titel des Tagungsbandes}


\renewcommand\title{\@ifnextchar[{\short@title}{\noshort@title}}
\def\short@title[#1]{\def\@titlemark{#1}\@settitle}
\def\shorttitleD#1{\def\@titlemark{#1}}
\def\noshort@title#1{\def\@titlemark{#1}\@settitle{#1}}
\def\@settitle#1{\gdef\@title{#1}}

\def\runheadstyle{\fontsize{8bp}{8bp}\selectfont}
\def\foliostyle{\fontsize{10bp}{10bp}\selectfont}

 \def\ps@headings{%
      \def\@oddfoot{\hbox to \textwidth{\hfill\foliostyle\thepage\hspace*{1.8pt}}}
      \def\@evenfoot{\hbox to \textwidth{\hspace*{-1.8pt}\foliostyle\thepage\hfill}}
      \def\@evenhead{%
\hbox to \textwidth{{\runheadstyle\@jtitle}\hfill}%
\llap{\raisebox{-3.2pt}[0pt][0pt]{\rule{\textwidth}{0.5bp}}}%
}
      \def\@oddhead{%
\hbox to \textwidth{\hfill{\runheadstyle\@titlemark}}%
\llap{\raisebox{-3.2pt}[0pt][0pt]{\rule{\textwidth}{0.5bp}}}%
}%
      \let\@mkboth\markboth
    \def\chaptermark##1{%
      \markboth {\MakeUppercase{%
        \ifnum \c@secnumdepth >\m@ne
          \if@mainmatter
            \@chapapp\ \thechapter. \ %
          \fi
        \fi
        ##1}}{}}%
    \def\sectionmark##1{%
      \markright {\MakeUppercase{%
        \ifnum \c@secnumdepth >\z@
          \thesection. \ %
        \fi
        ##1}}}}


\def\ps@fmheadings{%
      \def\@oddfoot{\hbox to \textwidth{\hfill\foliostyle\thepage\hspace*{1.8pt}}}
      \def\@evenfoot{\hbox to \textwidth{\hspace*{-1.8pt}\foliostyle\thepage\hfill}}
      \def\@evenhead{%
\hbox to \textwidth{{\runheadstyle\leftmark}\hfill}%
\llap{\raisebox{-3.2pt}[0pt][0pt]{\rule{\textwidth}{0.5bp}}}%
}
      \def\@oddhead{%
\hbox to \textwidth{\hfill{\runheadstyle\@rectohead}}%
\llap{\raisebox{-3.2pt}[0pt][0pt]{\rule{\textwidth}{0.5bp}}}%
}%
      \let\@mkboth\markboth
    \def\chaptermark##1{%
      \markboth {\MakeUppercase{%
        \ifnum \c@secnumdepth >\m@ne
          \if@mainmatter
            \@chapapp\ \thechapter. \ %
          \fi
        \fi
        ##1}}{}}%
    \def\sectionmark##1{%
      \markright {\MakeUppercase{%
        \ifnum \c@secnumdepth >\z@
          \thesection. \ %
        \fi
        ##1}}}}



  \def\ps@fheadings{%7.6
      \let\@oddfoot\@empty\let\@evenfoot\@empty
      \def\@evenhead{\rule[5mm]{105.3pt}{3mm}\hspace*{-5pt}\hspace*{5pt}%
      \rule[5mm]{134.45mm}{0.35pt}\hspace*{-160.45mm}\hspace*{-5pt}\hspace*{5pt}
      \hspace*{-11.9mm}\hbox to 36pt{%
      \fontsize{11}{13}\selectfont\sffamily\bfseries\thepage\hfill}%
%      {\fontsize{11}{13}\selectfont\sffamily\bfseries{\@chapapp}\ \thechapter}\hspace*{12pt}%
      {\sffamily\bfseries\fontsize{11}{13}\selectfont\leftmark}\hfill}%
\def\@oddhead{\rule[5mm]{134.45mm}{0.35pt}\hspace*{9pt}\hspace*{-9pt}\rule[5mm]{37.04mm}{3mm}\hskip-\paperwidth
      \hfill%
{\sffamily\bfseries\fontsize{11}{13}\selectfont\rightmark}%
{\hbox to 36pt{\hfill%
\fontsize{11}{13}\selectfont\sffamily\bfseries\thepage}}}%
\let\@mkboth\markboth
    \def\chaptermark##1{\markboth{{##1}}{}}%
    \def\sectionmark##1{\markright{{{
    \fontsize{11}{13}\selectfont{\thesection}\enspace}##1}}}}



\pagestyle{headings}
\pagenumbering{arabic}
\if@twoside
\else
  \raggedbottom
\fi
\if@twocolumn
  \twocolumn
  \sloppy
  \flushbottom
\else
  \onecolumn
\fi

\usepackage{xmpincl}

\if@prooffile
\prooffiles
\else
\fi

\def\pdfpageboxlayout#1#2#3#4{%
\pdfpageattr{/MediaBox #1%[0 0 684 855]
              /TrimBox #2%[36 36 648 819]
              /BleedBox #3%[27 27 657 828]
              /CropBox #4%[0 0 684 855]
%              /ArtBox [36 36 648 819]
               }
}


\if@printfile
\printfiles
%%%%%%%%%%%%%%%%%
%\pdfpageboxlayout{[0 0 491.04 855]}%MediaBox
%                 {[36 36 648 819]}%%TrimBox%%%
%                 {[27 27 657 828]}%BleedBox
%                 {[0 0 684 855]}%CropBox
\else
\fi



\vbadness=9999
\tolerance=9999
\doublehyphendemerits=10000
\doublehyphendemerits 640000   % corresponds to badness 800
\finalhyphendemerits  1000000  % corresponds to badness 1000

\def\enumerate{\@ifnextchar[{\@nenumerate}{\@nenumerate[0.]}}

\def\@nenumerate[#1]{%
  \ifnum \@enumdepth >\thr@@\@toodeep\else
    \advance\@enumdepth\@ne
    \edef\@enumctr{enum\romannumeral\the\@enumdepth}%
      \expandafter
      \list
        \csname label\@enumctr\endcsname
        {\usecounter\@enumctr\def\makelabel##1{\hss\llap{##1}}
\listparindent=12pt%
\settowidth\labelwidth{#1}
\parskip=0pt
\addtolength{\leftmargin}{\labelwidth}%
\advance\leftmargin by 2pt
\topsep 10.5\p@%
\partopsep=0pt%
\itemsep 8.5\p@%
        }%
  \fi}
\let\endenumerate =\endlist

\def\Aenumerate{\@ifnextchar[{\@Anenumerate}{\@Anenumerate[0.]}}

\def\@Anenumerate[#1]{%
  \ifnum \@enumdepth >\thr@@\@toodeep\else
    \advance\@enumdepth\@ne
    \edef\@enumctr{enum\romannumeral\the\@enumdepth}%
      \expandafter
      \list
        \csname label\@enumctr\endcsname
        {\usecounter\@enumctr\def\makelabel##1{\hss\llap{##1}}
\listparindent=17.5pt%
\parskip=0pt
\settowidth\labelwidth{#1}
\addtolength{\leftmargin}{\labelwidth}%
\advance\leftmargin by 2pt%
\topsep 10.5\p@%
\partopsep=0pt%
\itemsep 31\p@%
        }%
  \fi}
\let\endAenumerate =\endlist

\def\Denumerate{\@ifnextchar[{\@Dnenumerate}{\@Dnenumerate[0.]}}

\def\@Dnenumerate[#1]{%
  \ifnum \@enumdepth >\thr@@\@toodeep\else
    \advance\@enumdepth\@ne
    \edef\@enumctr{enum\romannumeral\the\@enumdepth}%
      \expandafter
      \list
        \csname label\@enumctr\endcsname
        {\usecounter\@enumctr%
\listparindent=17.5pt%
\settowidth\labelwidth{#1}
\parskip=0pt
\addtolength{\leftmargin}{\labelwidth}%
\addtolength{\leftmargin}{\labelsep}%
%\advance\leftmargin by 1pt%
\topsep 10.5\p@%
\partopsep=0pt%
\itemsep 36\p@%
\def\makelabel##1{\hss\llap{##1}}%
}%
\fi}
\let\endDenumerate =\endlist

\def\Wenumerate{\@ifnextchar[{\@Wnenumerate}{\@Wnenumerate[0.]}}

\def\@Wnenumerate[#1]{%
  \ifnum \@enumdepth >\thr@@\@toodeep\else
    \advance\@enumdepth\@ne
    \edef\@enumctr{enum\romannumeral\the\@enumdepth}%
      \expandafter
      \list
        \csname label\@enumctr\endcsname
        {\usecounter\@enumctr%
\listparindent=17.5pt%
\settowidth\labelwidth{#1}
\parskip=0pt
\addtolength{\leftmargin}{\labelwidth}%
\addtolength{\leftmargin}{\labelsep}%
\advance\leftmargin by -2pt%
\topsep 10.5\p@%
\partopsep=0pt%
\itemsep 29\p@%
\def\makelabel##1{\hss\llap{##1}}%
}%
\fi}
\let\endWenumerate =\endlist

\def\itemize{%
  \ifnum \@itemdepth >\thr@@\@toodeep\else
    \advance\@itemdepth\@ne
    \edef\@itemitem{labelitem\romannumeral\the\@itemdepth}%
    \expandafter
    \list
      \csname\@itemitem\endcsname
      {%\def\makelabel##1{\hss\llap{##1}}
\listparindent=17.5pt%
\parskip=0pt
\topsep 10.5\p@%
\partopsep=0pt%
\itemsep 8.5\p@%
\labelwidth=0pt%
\labelsep=11pt%
\leftmargin-0pt%
\leftskip=-29.5pt%
\itemindent26pt%
      }%
\fi}
\let\enditemize =\endlist

\def\psubenumerate{%
  \ifnum \@enumdepth >\thr@@\@toodeep\else
    \advance\@enumdepth\@ne
    \edef\@enumctr{enum\romannumeral\the\@enumdepth}%
      \expandafter
      \list
        \csname label\@enumctr\endcsname
        {\usecounter\@enumctr\def\makelabel##1{\hss\llap{##1)}}
\listparindent=17.5pt%
\renewcommand\labelenumi{\theenumi}
\topsep 0\p@%
\partopsep=0pt%
\parsep=0pt%
\itemsep 0pt%
\labelwidth=0pt%
\labelsep=8.25pt%
\leftmargin-0pt%
\leftskip=0pt%
\itemindent19pt%
}%
  \fi}
\let\endpsubenumerate =\endlist

\def\Qenumerate{\@ifnextchar[{\@Qnenumerate}{\@Qnenumerate[0.]}}

\def\@Qnenumerate[#1]{%
  \ifnum \@enumdepth >\thr@@\@toodeep\else
    \advance\@enumdepth\@ne
    \edef\@enumctr{enum\romannumeral\the\@enumdepth}%
      \expandafter
      \list
        \csname label\@enumctr\endcsname
        {\usecounter\@enumctr\def\makelabel##1{\hss\llap{##1}}
\listparindent=17.5pt%
\settowidth\labelwidth{#1}
\topsep 10.5\p@%
\partopsep=0pt%
\parsep=0pt%
\itemsep=35.5pt%
\addtolength{\leftmargin}{\labelwidth}%
%\addtolength{\leftmargin}{\labelsep}%
\advance\leftmargin by 2pt
}%
  \fi}
\let\endQenumerate =\endlist


\newenvironment{Unnumberedtable}{\begingroup\par\removelastskip\nointerlineskip\vspace*{12pt}\nointerlineskip\fontsize{8}{10}\selectfont}%
{\par\removelastskip\nointerlineskip\vspace*{12pt}\nointerlineskip\endgroup}

\newbox\Contelbox%
\newlength\Contellength%
\Contellength=414pt%

\def\ConstellLine#1{\begingroup\par%
\vspace*{5pt}%
\setbox\Contelbox\hbox{\bfseries#1}%
\advance\Contellength by -\wd\Contelbox%
\hbox to \textwidth{\hss\unhbox\Contelbox\space\underline{\hbox to
\Contellength{}}\hss}\par%
\endgroup}

\newbox\Namefourboxone%
\newbox\Namefourboxtwo%
\newbox\Namefourboxthree%
\newbox\Namefourboxfour%
\newlength\Fullfourlength%
\newlength\Fnamefourlength%
\newlength\Snamefourlength%
\newlength\Tnamefourlength%
\newlength\Fonamefourlength%
\Fullfourlength\textwidth
\advance\Fullfourlength by -27pt%
\divide\Fullfourlength 2%
\advance\Fullfourlength by -5pt%

\Fnamefourlength\Fullfourlength%
\Snamefourlength\Fullfourlength%
\Tnamefourlength\Fullfourlength%
\Fonamefourlength\Fullfourlength%

\def\namefour#1#2#3#4{\begingroup\par%
\vskip5pt%
\setbox\Namefourboxone\hbox{\bfseries#1}%
\setbox\Namefourboxtwo\hbox{\bfseries#2}%
\setbox\Namefourboxthree\hbox{\bfseries#3}%
\setbox\Namefourboxfour\hbox{\bfseries#4}%
\advance\Fnamefourlength by -\wd\Namefourboxone%
\advance\Snamefourlength by -\wd\Namefourboxtwo%
\advance\Tnamefourlength by -\wd\Namefourboxthree%
\advance\Fonamefourlength by -\wd\Namefourboxfour%
\hbox to \textwidth{\unhbox\Namefourboxone\space\underline{\hbox to
\Fnamefourlength{}}\hspace*{27pt}\unhbox\Namefourboxtwo\space\underline{\hbox to\Snamefourlength{}}}\par%
\vskip5pt%
\hbox to \textwidth{\unhbox\Namefourboxthree\space\underline{\hbox to
\Tnamefourlength{}}\hspace*{27pt}\unhbox\Namefourboxfour\space\underline{\hbox
to\Fonamefourlength{}}}\par%
\endgroup}


\newbox\ThreeNameboxone%
\newbox\ThreeNameboxtwo%
\newbox\ThreeNameboxthree%
\newlength\FullThreelength%
\newlength\FThreeNamelength%
\newlength\SThreeNamelength%
\newlength\TThreeNamelength%

\FullThreelength\textwidth
\advance\FullThreelength by -27pt%
\divide\FullThreelength 2%
\advance\FullThreelength by -5pt%

\FThreeNamelength\FullThreelength%
\SThreeNamelength\FullThreelength%
\TThreeNamelength\textwidth%

\gdef\Threename#1#2#3{\begingroup\par%
\vskip5pt%
\setbox\ThreeNameboxone\hbox{\bfseries#1}%
\setbox\ThreeNameboxtwo\hbox{\bfseries#2}%
\setbox\ThreeNameboxthree\hbox{\bfseries#3}%
\advance\FThreeNamelength by -\wd\ThreeNameboxone%
\advance\SThreeNamelength by -\wd\ThreeNameboxtwo%
\advance\TThreeNamelength by -\wd\ThreeNameboxthree%
\hbox to \textwidth{\unhbox\ThreeNameboxone\space\underline{\hbox to
\FThreeNamelength{}}\hspace*{27pt}\unhbox\ThreeNameboxtwo\space\underline{\hbox to\SThreeNamelength{}}}\par%
\vskip5pt%
\hbox to \textwidth{\unhbox\ThreeNameboxthree\space\underline{\hbox to
\TThreeNamelength{}}}\par%
\endgroup}

\usepackage{array}

\newenvironment{Longunnumberedtable}{\begingroup\par\removelastskip\nointerlineskip%
\vspace*{0pt}\nointerlineskip%\setlength{\extrarowheight}{29pt}%
\tabcolsep=16.228pt%
}{\par\removelastskip\nointerlineskip\vspace*{0pt}\nointerlineskip\endgroup%\setlength{\extrarowheight}{0pt}
}

\def\Tline{%
  \noalign{\ifnum0=`}\fi\hrule \@height \arrayrulewidth \futurelet
   \reserved@a\@xhline
\rule{0pt}{39pt}}

\newbox\FiveNameboxone%
\newbox\FiveNameboxtwo%
\newbox\FiveNameboxthree%
\newbox\FiveNameboxfour%
\newbox\FiveNameboxfive%

\newlength\FullFivelength%
\newlength\FFiveNamelength%
\newlength\SFiveNamelength%
\newlength\TFiveNamelength%
\newlength\FoFiveNamelength%
\newlength\FiFiveNamelength%

\FullFivelength\textwidth
\advance\FullFivelength by -27pt%
\divide\FullFivelength 2%
\advance\FullFivelength by -5pt%

\FFiveNamelength\FullFivelength%
\SFiveNamelength\FullFivelength%
\FoFiveNamelength\FullFivelength%
\FiFiveNamelength\FullFivelength%
\TFiveNamelength\textwidth%

\gdef\Fivename#1#2#3#4#5{\begingroup\par%
\vskip5pt%
\setbox\FiveNameboxone\hbox{\bfseries#1}%
\setbox\FiveNameboxtwo\hbox{\bfseries#2}%
\setbox\FiveNameboxthree\hbox{\bfseries#3}%
\setbox\FiveNameboxfour\hbox{\bfseries#4}%
\setbox\FiveNameboxfive\hbox{\bfseries#5}%
\advance\FFiveNamelength by -\wd\FiveNameboxone%
\advance\SFiveNamelength by -\wd\FiveNameboxtwo%
\advance\TFiveNamelength by -\wd\FiveNameboxthree%
\advance\FoFiveNamelength by -\wd\FiveNameboxfour%
\advance\FiFiveNamelength by -\wd\FiveNameboxfive%
\hbox to \textwidth{\unhbox\FiveNameboxone\space\underline{\hbox to
\FFiveNamelength{}}\hspace*{27pt}\unhbox\FiveNameboxtwo\space\underline{\hbox to\SFiveNamelength{}}}\par%
\vskip5pt%
\hbox to \textwidth{\unhbox\FiveNameboxthree\space\underline{\hbox to
\TFiveNamelength{}}}\par%
\vskip5pt%
\hbox to \textwidth{\unhbox\FiveNameboxfour\space\underline{\hbox to
\FoFiveNamelength{}}\hspace*{27pt}\unhbox\FiveNameboxfive\space\underline{\hbox
to\FiFiveNamelength{}}}\par%
\endgroup}

\def\dashlinefill{\cleaders\hbox{$\m@th \mkern1.5mu{{\hbox{-}}}\mkern1.5mu$}\hfill}

\def\ZenithDiagram{\begingroup%
\vbox to 368pt{\hsize\textwidth\centering\bfseries%
\vspace*{22pt}%
ZENITH\par
\vspace*{-6pt}%
x\par
\vfill
\hbox to \textwidth{\dashlinefill}\par%
\removelastskip\nointerlineskip\vspace*{4.1pt}\nointerlineskip%
\hbox to \textwidth{EAST\hfill SE\hfill SOUTH\hfill SW\hfill WEST}%
\vspace*{18pt}%
}%
\endgroup}%

\thinmuskip=2mu
\medmuskip=3mu% plus 2mu minus 4mu                <- no glue
\thickmuskip=4mu% plus 5mu                        <- no glue

\def\Boxnum#1{\noindent{\fbox{\bf #1.}}}

\def\steplist{%
  \ifnum \@enumdepth >\thr@@\@toodeep\else
    \advance\@enumdepth\@ne
    \edef\@enumctr{enum\romannumeral\the\@enumdepth}%
      \expandafter
      \list
        \csname label\@enumctr\endcsname
        {\usecounter\@enumctr\def\makelabel##1{\hss\llap{##1}}
\listparindent=17.5pt%
\renewcommand\labelenumi{\underline{Step~\theenumi:}\ }
\listparindent=17.5pt%
\parskip=0pt
\topsep 3\p@%
\partopsep=0pt%
\itemsep 3\p@%
\labelwidth=0pt%
\labelsep=0pt%
\leftmargin-0pt%
\leftskip=-29.5pt%
\itemindent58.5pt%
}%
  \fi}
\let\endsteplist =\endlist

\def\senumerate{%
  \ifnum \@enumdepth >\thr@@\@toodeep\else
    \advance\@enumdepth\@ne
    \edef\@enumctr{enum\romannumeral\the\@enumdepth}%
      \expandafter
      \list
        \csname label\@enumctr\endcsname
        {\usecounter\@enumctr\def\makelabel##1{\hss\llap{##1}}
\topsep 0\p@%
\partopsep=0pt%
\itemsep 31\p@%
\itemsep=0pt%
%\advance\leftmargin by -11pt%
}%
  \fi}
\let\endsenumerate =\endlist

\def\Asubenumerate{\@ifnextchar[{\@Asubnumerate}{\@Asubnumerate[0.]}}

\def\@Asubnumerate[#1]{%
  \ifnum \@enumdepth >\thr@@\@toodeep\else
    \advance\@enumdepth\@ne
    \edef\@enumctr{enum\romannumeral\the\@enumdepth}%
      \expandafter
      \list
        \csname label\@enumctr\endcsname
        {\usecounter\@enumctr\def\makelabel##1{\hss\llap{##1}}
\renewcommand\labelenumii{\theenumii.}
\settowidth\labelwidth{#1}
%\addtolength{\leftmargin}{\labelwidth}%
%\addtolength{\leftmargin}{\labelsep}%
\advance\leftmargin by -2pt%
\topsep 0\p@%
\partopsep=0pt%
\itemsep 31\p@%
%\advance\leftmargin by -11pt%
}%
  \fi}
\let\endAsubenumerate =\endlist

\def\eqrule{\underline{\hbox to 84pt{}}}

\def\subitemize{%
  \ifnum \@itemdepth >\thr@@\@toodeep\else
    \advance\@itemdepth\@ne
    \edef\@itemitem{labelitem\romannumeral\the\@itemdepth}%
    \expandafter
    \list
      \csname\@itemitem\endcsname
      {%\def\makelabel##1{\hss\llap{##1}}
\listparindent=17.5pt%
\parskip=0pt
\topsep 0\p@%
\partopsep=0pt%
\parsep=0pt%
\itemsep 0pt%
\labelwidth=0pt%
\labelsep=8.25pt%
\leftmargin-0pt%
\leftskip=0pt%
\itemindent\labelsep%
      }%
\fi}
\let\endsubitemize =\endlist

\newbox\SixNameboxone%
\newbox\SixNameboxtwo%
\newbox\SixNameboxthree%
\newbox\SixNameboxfour%
\newbox\SixNameboxfive%
\newbox\SixNameboxsix%

\newlength\FullSixlength%
\newlength\FSixNamelength%
\newlength\SSixNamelength%
\newlength\TSixNamelength%
\newlength\FoSixNamelength%
\newlength\FiSixNamelength%
\newlength\SiSixNamelength%

\FullSixlength\textwidth
\advance\FullSixlength by -27pt%
\divide\FullSixlength 2%
\advance\FullSixlength by -5pt%

\FSixNamelength\FullSixlength%
\SSixNamelength\FullSixlength%
\TSixNamelength\FullSixlength%
\FoSixNamelength\FullSixlength%
\FiSixNamelength\FullSixlength%
\SiSixNamelength\FullSixlength%

\gdef\Sixname#1#2#3#4#5#6{\begingroup\par%
\vskip5pt%
\setbox\SixNameboxone\hbox{\bfseries#1}%
\setbox\SixNameboxtwo\hbox{\bfseries#2}%
\setbox\SixNameboxthree\hbox{\bfseries#3}%
\setbox\SixNameboxfour\hbox{\bfseries#4}%
\setbox\SixNameboxfive\hbox{\bfseries#5}%
\setbox\SixNameboxsix\hbox{\bfseries#6}%
\advance\FSixNamelength by -\wd\SixNameboxone%
\advance\SSixNamelength by -\wd\SixNameboxtwo%
\advance\TSixNamelength by -\wd\SixNameboxthree%
\advance\FoSixNamelength by -\wd\SixNameboxfour%
\advance\FiSixNamelength by -\wd\SixNameboxfive%
\advance\SiSixNamelength by -\wd\SixNameboxsix%
\hbox to \textwidth{\unhbox\SixNameboxone\space\underline{\hbox to
\FSixNamelength{}}\hspace*{27pt}\unhbox\SixNameboxtwo\space\underline{\hbox to\SSixNamelength{}}}\par%
\vskip5pt%
\hbox to \textwidth{\unhbox\SixNameboxthree\space\underline{\hbox to
\TSixNamelength{}}\hspace*{27pt}\unhbox\SixNameboxfour\space\underline{\hbox
to\FoSixNamelength{}}}\par%
\vskip5pt%
\hbox to \textwidth{\unhbox\SixNameboxfive\space\underline{\hbox to
\FiSixNamelength{}}\hspace*{27pt}\unhbox\SixNameboxsix\space\underline{\hbox
to\SiSixNamelength{}}}\par%
\endgroup}

\newbox\TwoNameboxone%
\newbox\TwoNameboxtwo%
\newlength\FullTwolength%
\newlength\FTwoNamelength%
\newlength\STwoNamelength%

\FullTwolength\textwidth
\advance\FullTwolength by -27pt%
\divide\FullTwolength 2%
\advance\FullTwolength by -5pt%

\FTwoNamelength\FullTwolength%
\STwoNamelength\FullTwolength%

\gdef\Twoname#1#2{\begingroup\par%
\vskip5pt%
\setbox\TwoNameboxone\hbox{\bfseries#1}%
\setbox\TwoNameboxtwo\hbox{\bfseries#2}%
\advance\FTwoNamelength by -\wd\TwoNameboxone%
\advance\STwoNamelength by -\wd\TwoNameboxtwo%
\hbox to \textwidth{\unhbox\TwoNameboxone\space\underline{\hbox to
\FTwoNamelength{}}\hspace*{27pt}\unhbox\TwoNameboxtwo\space\underline{\hbox to\STwoNamelength{}}}\par%
\endgroup}

\def\Listword#1#2#3#4{\hbox{\bfseries\hspace*{45pt}#1\hspace*{32pt}#2\hspace*{32pt}#3\hspace*{32pt}#4\hfill}}

\newlength\Llength%

\def\Listwordthree#1#2{\begingroup\tabcolsep=14pt
\settowidth\Llength{#2}
\begin{tabular}{@{}p{\Llength}ll@{}}
#1 & \underline{\hbox to
46pt{}}&\underline{\hbox to 258pt{}}\end{tabular}\endgroup}

\usepackage{sidecap}
\usepackage{pifont}

\newcounter{PartTextcnt}

\def\thePartTextcnt{\Roman{PartTextcnt}}

\def\PartText#1{\begingroup\refstepcounter{PartTextcnt}\par\removelastskip\nointerlineskip\vspace*{14pt}\nointerlineskip%
\noindent {\bfseries Part~\thePartTextcnt:\
#1}\par\removelastskip\nointerlineskip\vspace*{4.3pt}\nointerlineskip%
\endgroup}

\def\Dingrarrow{\ding{212}}

\def\ListfollowedSect{\vspace*{6pt}}

\def\bfit#1{\textbf{\textit{#1}}}

\def\textsb#1{{\selectfont#1}}

\def\contspace{\vspace*{12pt}}

\newcommand{\civ}{C\,{\sc iv}}
\newcommand{\kms}{km\,s$^{-1}$}
\newcommand{\lya}{Ly$\alpha$}
\newcommand{\mgii}{Mg\,{\sc ii}}
\newcommand{\oii}{[O\,{\sc ii}]}
\newcommand{\oiii}{[O\,{\sc iii}]}

\def\namethree{\noindent{\bf Name:\underline{\hspace*{158pt}}
ID\#:\underline{\hspace*{106pt}}
Date:\underline{\hspace*{108pt}}}}

\frenchspacing

\def\@seccntformat#1{\hbox to 40pt{\csname the#1\endcsname\hfill}}

\def\@sect#1#2#3#4#5#6[#7]#8{%
  \ifnum #2>\c@secnumdepth
    \let\@svsec\@empty
  \else
    \refstepcounter{#1}%
    \protected@edef\@svsec{\@seccntformat{#1}\relax}%
  \fi
  \@tempskipa #5\relax
  \ifdim \@tempskipa>\z@
    \begingroup
    \ifnum#2=1\else\fi
      #6{%
        \@hangfrom{\hskip #3\relax{\@svsec}}%
          \interlinepenalty \@M \ifnum#2=1{#8} \else {#8} \fi \@@par}%
    \endgroup
    \csname #1mark\endcsname{#7}%
    \addcontentsline{toc}{#1}{%
      \ifnum #2>\c@secnumdepth \else
        \protect\numberline{\csname the#1\endcsname}%
      \fi
      #8}\@afterindentfalse
  \@afterheading%
  \else
    \def\@svsechd{%
      #6{\hskip #3\relax
      \@svsec #8}%
      \csname #1mark\endcsname{#7}%
      %\addcontentsline{toc}{#1}{%
      %  \ifnum #2>\c@secnumdepth \else
      %    \protect\numberline{\csname the#1\endcsname}%
      %  \fi
      %  #8}
        }%
  \fi
  \@xsect{#5}
}


\newcounter{ttheorem}

%%% from preamble part
\usepackage{breakurl}
\usepackage{lipsum}
\usepackage{fmtcount}

\newcommand\subpartautorefname{\subpartname}
\newcommand\subpartbreak{\cleardoublepage\mbox{}\vfil}

\makeatletter
\newcommand*\l@subpart[2]{%
  \ifnum \c@tocdepth >-2\relax
    \addpenalty{-\@highpenalty}%
    \addvspace{1em \@plus\p@}%
    \setlength\@tempdima{3.9em}%
    \begingroup
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      {\leavevmode
       \fontsize{12}{14}\selectfont Subpart~#1\hfil\hb@xt@\@pnumwidth{\hss #2}}\par
       \nobreak
         \global\@nobreaktrue
         \everypar{\global\@nobreakfalse\everypar{}}%
    \endgroup
  \fi}
\makeatother
% def of subpart end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% providing if-then-else command:
\usepackage{ifthen}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\usepackage[english]{babel}%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% caption settings:
\usepackage{newfloat}
\usepackage[nooneline]{caption}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Define the depth of numbering parts,chapter,sections and paragraphs:
%%   Numbers representing the depth of sectional units:
%%   -1 = \part    (in book or report document classes)
%%    0 = \chapter (in book or report document classes)
%%    0 = \part    (in article document classes)
%%    1 = \section
%%    2 = \subsection
%%    3 = \subsubsection
%%    4 = \paragraph
%%    5 = \subparagraph
\setcounter{secnumdepth}{5}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% citation style:


\newcommand{\bibpc}{{
\footnotesize
\parskip0pt
\setlength{\bibsep}{0.2em}
\bibliographystyle{0/template_ivt-eng}
\bibliography{0/added_bibs,0/ivt_bibs,0/tub,0/ref-gunnar,0/michalm_matsim_book,0/laemmel}
\normalsize
}
}% bibliography per chapter

\def\betaperf{\beta_{\it dur}}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\usepackage{ifthen}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\usepackage[usenames,dvipsnames,table]{xcolor}
\usepackage{xargs}
\usepackage[colorinlistoftodos,prependcaption,textsize=footnotesize]{todonotes}
\usepackage{colortbl}

\newcommandx{\atend}[2][1=]{\todo[linecolor=yellow,backgroundcolor=yellow!25,bordercolor=yellow,#1]{at end: #2}}
\newcommandx{\kaitodo}[2][1=]{\todo[linecolor=red,backgroundcolor=red!25,bordercolor=red,#1]{kai: #2}}
\let\todokai=\kaitodo
\newcommandx{\ahtodo}[2][1=]{\todo[linecolor=blue,backgroundcolor=blue!25,bordercolor=blue,#1]{ah: #2}}
\let\todoah=\ahtodo
\newcommandx{\someonetodo}[2][1=]{\todo[linecolor=yellow,backgroundcolor=yellow!25,bordercolor=yellow,#1]{someone: #2}}
\let\todosomeone=\someonetodo
\newcommandx{\bktodo}[2][1=]{\todo[linecolor=OliveGreen,backgroundcolor=OliveGreen!25,bordercolor=OliveGreen,#1]{bk: #2}}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Font:
%\usepackage{times}
%\RequirePackage{up-font}

\makeatletter
\usepackage[LY1]{fontenc}
\renewcommand{\rmdefault}{Calibri-TLF}
\pdfmapfile{+Calibri.map}
\makeatother

%\usepackage[LY1]{fontenc}
%\renewcommand{\rmdefault}{Calibri-TLF}
%\RequirePackage[OT1,mtbold]{ubiquity-palatino}


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% To prevent overfull boxes
%%   it is quite nice, but in special cases, you will have too large
%%   speaces between a two words of the same line.
\sloppy
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% providing umlauts:
%\usepackage[latin1]{inputenc}
%\usepackage[T1]{fontenc}
%%\usepackage[utf8]{inputenc}
\usepackage{ifxetex}
\ifxetex
  \usepackage{fontspec}
  \usepackage{xunicode}
  \usepackage{xltxtra}
\else
  \usepackage[utf8]{inputenc}
\fi
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% line spacing
\usepackage{setspace}
%\onehalfspacing
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% letter spacing [[?????]]
\usepackage{soul}
%%\usepackage{ulem}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% no indentation for formulas:
%\usepackage[fleqn]{amsmath}
\usepackage{amsmath}
%\setlength\mathindent{0pt}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% providing graphics:
%%\usepackage{graphics} % I don't think we need both.  Do we?  kai, jan'16
\usepackage{graphicx}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% sideways figures and tables:
\usepackage[figuresright]{rotating}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% sub-figures:
\usepackage[tight]{subfigure}
\def\subfigtopskip{0pt}
\def\subfigbottomskip{5pt}
\def\subfigcapskip{0pt}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% figures:
%%   The following are sometimes needed to avoid pushing
%%   the figs to the end of the text.
\def\textfraction{0.0}
\def\topfraction{0.9999}
\def\floatpagefraction{0.9}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% tables:
\usepackage{tabularx}
\usepackage{multirow}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\usepackage{hyphenat} % for \hyp support
\usepackage{fixltx2e} % for \textsubscript{...}
\usepackage{booktabs}   % for \toprule. \midrule, \bottomrule in tables
\usepackage{verbatim}
\usepackage{amssymb}    % for \checkmark
\usepackage{amsmath}
\usepackage{amsbsy}
\usepackage{pifont} % for \xmark and \xmark
\newcommand{\cmark}{\ding{51}}% another checkmark symbol
\newcommand{\xmark}{\ding{55}}% an xmark symbol

\usepackage{tikz} % for diagonal line in tables
\usepackage{afterpage} % for  \afterpage{\clearpage}
\usepackage{paralist}   % for compactitems
\usepackage{multicol}
\usepackage{longtable}
\usepackage[bottom]{footmisc}
%\usepackage{algorithmic}
\usepackage{color}
\usepackage{marvosym}
\usepackage{verbatim}
\usepackage[section]{placeins}
\usepackage{eurosym}
%\usepackage{bookmark,hyperref}
%\usepackage{matsimbook}
\usepackage{framed}
\usepackage{array}
\usepackage{wrapfig}
\usepackage{fixmath}
\usepackage{makeidx}
%\makeindex

\usepackage{hhline}
% make gls entries in the following format ``acr (long desc)''
\AtBeginDocument{%
\defglsdisplayfirst[\acronymtype]{%
\glsifplural{\glsentryshortpl{\glslabel} (\glsentrylongpl{\glslabel})#4}{\glsentryshort{\glslabel} (\glsentrylong{\glslabel})#4\hskip-.4pt}%
}%
\renewcommand*{\glsdisplay}[4]{#1#4\hskip-.4pt}
}

\usepackage{csquotes}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% make definition of abbreviations easier
\usepackage{xspace}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% allows to use full-page background pictures, e.g. for part-titles
\usepackage{wallpaper}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% alternative to paralist
\newcommand{\styleEnumerate}{%
    %\setlength{\itemsep}{-\parskip}%
    %\setlength{\topsep}{-5pt}%
\addtolength{\leftmargin}{12pt}
}

\newcommand{\styleEnumerates}{%
    %\setlength{\itemsep}{-\parskip}%
    %\setlength{\topsep}{-5pt}%
}

\newcommand{\styleItemize}{%
    \styleEnumerates%
\setlength  \labelsep  {.5pt}
    % at the moment, this does not differ from the enumeration-style
}
\newcommand{\styleDescription}{%
    \styleEnumerates%
    % at the moment, this does not differ from the enumeration-style
}



\usepackage{enumitem}
\setlist{itemsep=0pt, topsep=8pt, parsep=0pt, partopsep=0pt,
leftmargin=18pt}
% I changed parsep to same as itemsep.  I find this easier to read, and I think that it looks cleaner.  If not ok, pls change back.  Kai, aug'15

\makeatletter
\def\enumerate{\def\styleEnumerate{}\@ifnextchar[{\@nenumerate}{\@nenumerate[0.]}}

\def\@nenumerate[#1]{%
  \ifnum \@enumdepth >\thr@@\@toodeep\else
    \advance\@enumdepth\@ne
    \edef\@enumctr{enum\romannumeral\the\@enumdepth}%
      \expandafter
      \list
        \csname label\@enumctr\endcsname
        {\usecounter\@enumctr\def\makelabel##1{\hss\llap{##1}}
\listparindent=0pt%
\settowidth\labelwidth{#1}
\parskip=0pt
\addtolength{\leftmargin}{\labelwidth}%
\advance\leftmargin by -1pt
\topsep 8\p@%
\partopsep=0pt%
\itemsep 3\p@%
        }%
  \fi}
\let\endenumerate =\endlist



\def\enumargs{%
   \leftmargini   0pt
   \topsep     8.1pt
   \itemsep       3pt
   \parsep        \z@
   \labelsep      7pt
   \rightmargin   \z@
   \listparindent 0pt%\parindent
   \itemindent    \z@}

\def\enumerate{\let\enumerate\subenumerate%
    \@ifnextchar[{\@numerate}{\@numerate[0.]}}

\def\@numerate[#1]{%
     \ifnum \@enumdepth >3 \@toodeep\else
     \advance\@enumdepth \@ne
     \edef\@enumctr{enum\romannumeral\the\@enumdepth}
     \list{\csname label\@enumctr\endcsname}{%
       \enumargs
       \setlength{\leftmargin}{\csname leftmargin\romannumeral\the\@enumdepth\endcsname}
       \usecounter{\@enumctr}
       \settowidth\labelwidth{#1}
       \addtolength{\leftmargin}{\labelwidth}
       \addtolength{\leftmargin}{\labelsep}
              \addtolength{\leftmargin}{8pt}
       \def\makelabel##1{\hss\llap{##1}}}%
     \fi
   }
\let\endenumerate\endlist

\def\subenumargs{%
   \leftmargini   0pt
   \topsep     3.1pt
   \itemsep       3pt
   \parsep        \z@
   \labelsep      7pt
   \rightmargin   \z@
   \listparindent 0pt%\parindent
   \itemindent    \z@}

\def\subenumerate{%
    \@ifnextchar[{\@subnumerate}{\@subnumerate[0.]}}

\def\@subnumerate[#1]{%
     \ifnum \@enumdepth >3 \@toodeep\else
     \advance\@enumdepth \@ne
     \edef\@enumctr{enum\romannumeral\the\@enumdepth}
     \list{\csname label\@enumctr\endcsname}{%
       \subenumargs
       \setlength{\leftmargin}{\csname leftmargin\romannumeral\the\@enumdepth\endcsname}
       \usecounter{\@enumctr}
       \settowidth\labelwidth{#1}
       \addtolength{\leftmargin}{\labelwidth}
       \addtolength{\leftmargin}{\labelsep}
              \addtolength{\leftmargin}{-16pt}
       \def\makelabel##1{\hss\llap{##1}}}%
     \fi
   }
\let\endsubenumerate\endlist


\def\itemargs{%
   \leftmargini   0\p@
   \addtolength\leftmargini{-.4mm}
   \topsep     3.1pt
   \itemsep       .1pt
   \parsep        \z@
   \labelsep      8pt
   \rightmargin   \z@
   \listparindent \parindent
   \itemindent    \z@}

\def\itemize{\let\itemize\subitemize%
   \@ifnextchar[{\@itemize}{\@itemize[$\bullet$]}}

\def\@itemize[#1]{%
     \ifnum \@itemdepth >3 \@toodeep\else
     \advance\@itemdepth \@ne
     \edef\@itemctr{item\romannumeral\the\@itemdepth}
     \list{\csname label\@itemctr\endcsname}{%
       \itemargs
       \setlength{\leftmargin}{\csname leftmargin\romannumeral\the\@itemdepth\endcsname}
       \settowidth\labelwidth{#1}
       \addtolength{\leftmargin}{\labelwidth}
       \addtolength{\leftmargin}{\labelsep}
       \addtolength{\leftmargin}{17pt}
       \def\makelabel##1{\hss \llap{##1\hskip1pt}}}%
     \fi
   }
\let\enditemize\endlist



\def\subitemargs{%
   \leftmargini   0\p@
   \addtolength\leftmargini{-.4mm}
   \topsep     3.1pt
   \itemsep       3pt
   \parsep        \z@
   \labelsep      0.5em
   \rightmargin   \z@
   \listparindent \parindent
   \itemindent    \z@}

\def\subitemize{%
   \@ifnextchar[{\@subitemize}{\@subitemize[$\bullet$]}}

\def\@subitemize[#1]{%
     \ifnum \@itemdepth >3 \@toodeep\else
     \advance\@itemdepth \@ne
     \edef\@itemctr{item\romannumeral\the\@itemdepth}
     \list{\csname label\@itemctr\endcsname}{%
       \subitemargs
       \setlength{\leftmargin}{\csname leftmargin\romannumeral\the\@itemdepth\endcsname}
       \settowidth\labelwidth{#1}
       \addtolength{\leftmargin}{\labelwidth}
       \addtolength{\leftmargin}{\labelsep}
       \addtolength{\leftmargin}{-18pt}
       \def\makelabel##1{\hss \llap{##1}}}%
     \fi
   }
\let\endsubitemize\endlist


\def\numberlist{%
    \@ifnextchar[{\@numberlist}{\@numberlist[0.]}}

\def\@numberlist[#1]{%
     \ifnum \@enumdepth >3 \@toodeep\else
     \advance\@enumdepth \@ne
     \edef\@enumctr{enum\romannumeral\the\@enumdepth}
     \list{\csname label\@enumctr\endcsname}{%
          \leftmargini   20pt
          \topsep     3.1pt
          \itemsep       3pt
          \parsep        \z@
          \labelsep      7pt
          \rightmargin   \z@
           \listparindent 0pt%\parindent
           \itemindent    \z@
       \setlength{\leftmargin}{\csname leftmargin\romannumeral\the\@enumdepth\endcsname}
       \usecounter{\@enumctr}
       \settowidth\labelwidth{#1}
       \addtolength{\leftmargin}{\labelwidth}
       \addtolength{\leftmargin}{\labelsep}
       \addtolength{\leftmargin}{-16pt}
       \def\makelabel##1{\hss\llap{##1}}}%
     \fi
   }
\let\endnumberlist\endlist

\def\alphalist{%
    \@ifnextchar[{\@alphalist}{\@alphalist[0.]}}

\def\@alphalist[#1]{%
     \ifnum \@enumdepth >3 \@toodeep\else
     \advance\@enumdepth \@ne
     \edef\@enumctr{enum\romannumeral\the\@enumdepth}
     \list{\csname label\@enumctr\endcsname}{\renewcommand\theenumi{\@alph\c@enumi}%
          \leftmargini   20pt
          \topsep     3.1pt
          \itemsep       3pt
          \parsep        \z@
          \labelsep      7pt
          \rightmargin   \z@
           \listparindent 0pt%\parindent
           \itemindent    \z@
       \setlength{\leftmargin}{\csname leftmargin\romannumeral\the\@enumdepth\endcsname}
       \usecounter{\@enumctr}
       \settowidth\labelwidth{#1}
       \addtolength{\leftmargin}{\labelwidth}
       \addtolength{\leftmargin}{\labelsep}
              \addtolength{\leftmargin}{-16pt}
       \def\makelabel##1{\hss\llap{##1}}}%
     \fi
   }
\let\endalphalist\endlist

\def\descriptive{%
    \@ifnextchar[{\@descriptive}{\@descriptive[0.]}}

\def\@descriptive[#1]{\vskip5pt%
     \ifnum \@enumdepth >3 \@toodeep\else
     \advance\@enumdepth \@ne
     \edef\@enumctr{enum\romannumeral\the\@enumdepth}
     \list{\csname label\@enumctr\endcsname}{\renewcommand\theenumi{\c@enumi}%
          \leftmargini   20pt
          \topsep     3.1pt
          \itemsep       3pt
          \parsep        \z@
          \labelsep      7pt
          \rightmargin   \z@
           \listparindent 0pt%\parindent
           \itemindent    \z@
       \setlength{\leftmargin}{\csname leftmargin\romannumeral\the\@enumdepth\endcsname}
       \usecounter{\@enumctr}
       \settowidth\labelwidth{#1}
       \addtolength{\leftmargin}{\labelwidth}
       \addtolength{\leftmargin}{\labelsep}
              \addtolength{\leftmargin}{-0pt}
       \def\makelabel##1{\hss\llap{\bfseries\itshape##1}}}%
     \fi
   }
\let\enddescriptive\endlist

\def\romanlist{%
    \@ifnextchar[{\@romanlist}{\@romanlist[0.]}}

\def\@romanlist[#1]{%
     \ifnum \@enumdepth >3 \@toodeep\else
     \advance\@enumdepth \@ne
     \edef\@enumctr{enum\romannumeral\the\@enumdepth}
     \list{\csname label\@enumctr\endcsname}{\renewcommand\theenumi{\@roman\c@enumi}%
          \leftmargini   20pt
          \topsep     3.1pt
          \itemsep       3pt
          \parsep        \z@
          \labelsep      7pt
          \rightmargin   \z@
           \listparindent 0pt%\parindent
           \itemindent    \z@
       \setlength{\leftmargin}{\csname leftmargin\romannumeral\the\@enumdepth\endcsname}
       \usecounter{\@enumctr}
       \settowidth\labelwidth{#1}
       \addtolength{\leftmargin}{\labelwidth}
       \addtolength{\leftmargin}{\labelsep}
              \addtolength{\leftmargin}{-16pt}
       \def\makelabel##1{\hss\llap{##1}}}%
     \fi
   }
\let\endromanlist\endlist


\def\bulletlist{%
   \@ifnextchar[{\@bulletlist}{\@bulletlist[$\bullet$]}}

\def\@bulletlist[#1]{%
     \ifnum \@itemdepth >3 \@toodeep\else
     \advance\@itemdepth \@ne
     \edef\@itemctr{item\romannumeral\the\@itemdepth}
     \list{\csname label\@itemctr\endcsname}{%
          \leftmargini   0\p@
   \addtolength\leftmargini{-.4mm}
   \topsep     8.1pt
   \itemsep       .1pt
   \parsep        \z@
   \labelsep      0.5em
   \rightmargin   \z@
   \listparindent \parindent
   \itemindent    \z@
       \setlength{\leftmargin}{\csname leftmargin\romannumeral\the\@itemdepth\endcsname}
       \settowidth\labelwidth{#1}
       \addtolength{\leftmargin}{\labelwidth}
       \addtolength{\leftmargin}{\labelsep}
       \addtolength{\leftmargin}{5.15pt}
       \def\makelabel##1{\hss\llap{##1\hskip1pt}}}%
     \fi
   }
\let\endbulletlist\endlist

\def\unnumberedlist{%
   \@ifnextchar[{\@unnumberedlist}{\@unnumberedlist[]}}


\def\@unnumberedlist[#1]{%
     \ifnum \@itemdepth >3 \@toodeep\else
     \advance\@itemdepth \@ne
     \edef\@itemctr{item\romannumeral\the\@itemdepth}
     \list{\csname label\@itemctr\endcsname}{%
          \leftmargini   0\p@
   \addtolength\leftmargini{-.4mm}
   \topsep     8.1pt
   \itemsep       .1pt
   \parsep        \z@
   \labelsep      0.5em
   \rightmargin   \z@
   \listparindent \parindent
   \itemindent    \z@
       \setlength{\leftmargin}{\csname leftmargin\romannumeral\the\@itemdepth\endcsname}
       \settowidth\labelwidth{#1}
       \addtolength{\leftmargin}{\labelwidth}
       \addtolength{\leftmargin}{\labelsep}
       \addtolength{\leftmargin}{5.15pt}
       \def\makelabel##1{\hss\llap{##1\hskip1pt}}}%
     \fi
   }
\let\endunnumberedlist\endlist

\makeatother


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% BDI:
\usepackage{tikz,pgf,pgfplots}
\usetikzlibrary{arrows,decorations,backgrounds,matrix,automata,
trees,shapes,shadows,plotmarks,calc,positioning,patterns,chains,fit}

\usepackage{epsfig}
\usepackage{pdfpages}
\usepackage{tablefootnote}

\newcounter{bean}

\newenvironment{tightenumerate}{
                \begin{list}{
                  {\mbox {
                      \arabic{bean}.\/}}}{\usecounter{bean}
                      \setlength{\itemsep}{-1pt}\setlength{\topsep}{0pt}}}{
                \end{list}}

\newenvironment{tightitemize}{
                \begin{list}{$\bullet$}{
                    \setlength{\itemsep}{-1pt}}{\setlength{\topsep}{0pt}}}{
                \end{list}}

\newcommand{\Omit}[1]{}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% pretty printing:
\usepackage{listings}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%
%% The following defines language specific words
%%   These are internal commands. They are not used in the main file.
%%   Langugage specific word commands always starts with '\word'
%%
%% Quelle/Source
\newcommand{\wordsource}{\iflanguage{english}{Source:\ }{\iflanguage{german}{Quelle:\ }{\langerrmessage}}}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% \internmakethreecolumns{entry1}{entry2}{entry3}
%%   creates a table with three columns containing the given entries
\newcommand{\internmakethreecolumns}[3]{
  \noindent
  \begin{tabular*}{\textwidth}{@{}l@{}l@{}l@{}}
    #1 & #2 & #3 \\
  \end{tabular*}
}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Figure definition
%%   \createfigure[<pos>]
%%     {<short caption>}
%%     {<long caption>}
%%     {<\label{label}>}
%%     {<\includegraphics[...]{figure}>}
%%     {<source>or<>}
\newcommand{\createfigure}[6][htp]{%
\begin{figure}[#1] % do not indent this line; produces unwanted spaces.  kai, dec'14
    \hrule
    \begin{center}
      #5\\
    \end{center}
    \ifthenelse
      {\equal{#6}{}}
      {}
      {\wordsource #6 \vspace{0.5em}}
    \hrule
    \vspace{0.5em}
    \caption[#2]{#3.} #4
  \end{figure}%
}
% The syntax "[6][htp]{...[#1]..." means that the first parameter is
% optional. kai, dec'14
%
% Kommentar Kai: Mir macht diese private
% Definition einige Probleme, weil mein emacs syntax-parser (der
% z.B. bei den Querverweisen hilft), damit natrlich nicht zurecht
% kommt. :-(
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Sideways figure definition
%%   \createfigure
%%     {<short caption>}
%%     {<long caption>}
%%     {<\label{label}>}
%%     {<\includegraphics[...]{figure}>}
%%     {<source>or<>}
\newcommand{\createsidewaysfigure}[5]{
  \begin{sidewaysfigure}
    \caption[#1]{#2.} #3
    \vspace{0.5em}
    \hrule
    \begin{center}
      #4\\
    \end{center}
    \ifthenelse
      {\equal{#5}{}}
      {}
      {\wordsource #5 \vspace{0.5em}}
    \hrule
  \end{sidewaysfigure}
}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Sub-figure:
%%   \createsubfigure
%%     {<caption>}
%%     {<\includegraphics[...]{figure}>}
%%     {<\label{label}>}
%%     {<\\>or<>}%

\newcommand{\createsubfigure}[4]{
  \subfigure[#1.]{%
    #2%
    #3%
  }#4
}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Table:
%%   \createtable
%%     {<short caption>}
%%     {<long caption>}
%%     {<\label{label}>}
%%     {<\begin{tabular}...\end{tabular}>}
%%     {<source>or<>}
\newcommand{\createtable}[6][htp]{
  \begin{table}[#1]
    \caption[#2]{#3.} #4
    \vspace{0.5em}
    \hrule
    \begin{center}
      #5\\
    \end{center}
    \ifthenelse
      {\equal{#6}{}}
      {}
      {\wordsource #6 \vspace{0.5em}}
    \hrule
  \end{table}
}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Sideways table definition
%%   \createsidewaystable
%%     {<short caption>}
%%     {<long caption>}
%%     {<\label{label}>}
%%     {<\begin{tabular}...\end{tabular}>}
%%     {<source>or<>}
\newcommand{\createsidewaystable}[5]{
  \begin{sidewaystable}
    \caption[#1]{#2} #3
    \vspace{0.5em}
    \hrule
    \begin{center}
      #4\\
    \end{center}
    \ifthenelse
      {\equal{#5}{}}
      {}
      {\wordsource #5 \vspace{0.5em}}
    \hrule
  \end{sidewaystable}
}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% XML-figure
%%   \createxmlfigure
%%     {<short caption>}
%%     {<long caption>}
%%     {<\label{label}>}
%%     {<the/file/with/the/xml/code/to/include>}
%%     {<source>or<>}
\newcommand{\createxmlfigure}[5]{
  \begin{figure}
    \hrule
    \lstset{language=XML}
    \lstinputlisting{#4}
    \ifthenelse
      {\equal{#5}{}}
      {}
      {\wordsource #5 \vspace{0.5em}}
    \hrule
    \vspace{0.5em}
    \caption[#1]{\kai{if this is used, its formatting will be different from other xml. kai, apr'15}#2.} #3
  \end{figure}
}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Contact
%%   \createcontact
%%     {<Name>}
%%     {<andreas line 1>}
%%     {<andreas line 1>}
%%     {<andreas line 3>}
%%     {<phone number>}
%%     {<fax number>}
%%     {<email address>}
\newcommand{\createcontact}[7]{
  \ifthenelse{\equal{#1}{}}{%
    \noindent\parbox[][][l]{0.33\textwidth}{
    }%
  }{%
    \noindent\parbox[][][l]{0.33\textwidth}{
      #1\newline
      #2\newline
      #3\newline
      #4\newline
      \wordphone: #5\newline
      \wordfax: #6\newline
      #7\newline
    }%
  }%
}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% New titlepage definition
\newcommand{\createtitlepage}{
  \begin{titlepage}
    \ThisCenterWallPaper{1.0}{figures/titlepage.pdf}
    \begin{center}
      \bigskip
    \end{center}
  \end{titlepage}
  \cleardoublepageempty
}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newcommand{\createStandardInformationBasic}[4]{{\lstset{basicstyle=\footnotesize\tt}%
%
\noindent\textbf{Entry point to documentation:}
\\[3pt]
#1\vspace*{3pt}

\noindent\textbf{Invoking the module:}
\\[3pt]
#2\vspace*{3pt}

%%\noindent\textbf{Configuration:}
%%\\
%%#3

\noindent\textbf{Selected publications:}
\\[3pt]
#4
%
}}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% \ah{changed from extension to contribution, trying to be as specific is possible. This command so far is only used for contributions.}

\newcommand{\entryStd}[1]{\url{http://matsim.org/extensions} $\to$ #1}

\newcommand{\invokeStd}[2]{\url{http://matsim.org/javadoc} $\to$ #1 $\to$ #2}

\newcommand{\invokeNonstd}[2]{No predefined invocation.  Starting point(s) under \url{http://matsim.org/javadoc} $\to$ #1 $\to$ #2.}

\newcommand{\configStd}[2]{\lstinline{#2} section(s) of the config file (only available when the #1 contribution is correctly loaded).}

\newcommand{\configNonstd}{Currently no config section available.}

\newcommand{\pubNone}{--}

\newcommand{\createStandardInformation}[4]{{\lstset{basicstyle=\footnotesize\tt}%
%
\section{Basic Information}
\label{sec:#1-stdInfo}
%
\noindent\textbf{Entry point to documentation:}
\\[3pt]
\entryStd{#1}\vspace*{3pt}

\noindent\textbf{Invoking the module:}
\\[3pt]
\invokeStd{#1}{#2}\vspace*{3pt}

%%\noindent\textbf{Configuration:}
%%\\
%%\configStd{#1}{#3}
%
\noindent\textbf{Selected publications:}
\\[3pt]
#4
%
}}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\definecolor{gray(x11gray)}{rgb}{0.75, 0.75, 0.75}
\definecolor{navyblue}{rgb}{0.0, 0.0, 0.5}
\definecolor{oceanboatblue}{rgb}{0.0, 0.47, 0.75}
\definecolor{steelblue}{rgb}{0.27, 0.51, 0.71}
\definecolor{lightgray}{rgb}{0.83, 0.83, 0.83}
\colorlet{shadecolor}{gray!20}

\usepackage{listings}
\lstset{%
%
breaklines=true,
backgroundcolor=\color{shadecolor},
%
language=Java,%
aboveskip=9pt,belowskip=9pt,%belowskip=-0pt,% ???
%basicstyle=\ttfamily\lst@ifdisplaystyle\fontsize{8}{9}\selectfont\fi,%
basicstyle=\ttfamily\lst@ifdisplaystyle\fontsize{8}{9}\selectfont\else\fontsize{9}{13}\selectfont\fi,%
lineskip=-0pt,% ???
keywordstyle=\lst@ifdisplaystyle\bfseries\color{blue}\fi,%
keywordstyle={[2]\lst@ifdisplaystyle\bfseries\color{magenta}\fi},%
commentstyle=\bfseries\lst@ifdisplaystyle\color{red}\fi,%
stringstyle=\bfseries\lst@ifdisplaystyle\color{ForestGreen}\fi,%
showstringspaces=false,%
frame=single,rulecolor=\color{shadecolor},xrightmargin=3pt,xleftmargin=3pt,framexrightmargin=-1pt,framexleftmargin=-1pt,%
string=[b]",morekeywords={},morekeywords={[2]%
%
Comparator,String,
%
List,ArrayList,Map,TreeMap,HashMap,LinkedList,Set,Comparable,Collection,
%
% config and related:
Config,ConfigUtils,ConfigGroup,ReflectiveConfigGroup,
%
% scenario and related:
Id,Coord,Scenario,ScenarioUtils,
%
Population,Person,Plan,Activity,Leg,PlanElement,
%
Network,Link,Node,
%
Vehicle,
%
% controler and related:
Controler,EventsManager,StartupListener,StartupEvent,
%
% mobsim and related:
MobsimDriverPassengerAgent,PersonDriverAgentImpl,ActivityEngine,AgentSource,TeleportationEngine,
%
MobSim,QSim,MobsimAgent,DriverAgent,
%
TransitSchedule,
%
% important contribs (debatable if this should be highlighted):
RoadPricing,
%
DynAgent,DynAgentLogic,RandomDynLeg,RandomDynActivity,DynActivity,DynLeg,DriverDynLeg,PTPassengerDynLeg,%
PlanToDynAgentLogicAdapter,DynActivityEngine,DynAgentLauncherUtils,RandomDynActivity,RandomDynLeg,
%
}}

%I don't know why one needs a negative belowskip to get the space symmetric to the aboveskip.  %
%Maybe this happens as long as one has parskip > 0?? kai, jan'15

\makeatletter
\lstnewenvironment{xml}{\lstset{%
%
backgroundcolor=\color{shadecolor},
%
frame=single,rulecolor=\color{shadecolor},framesep=2pt,xrightmargin=2pt,xleftmargin=2pt,framexrightmargin=2pt,%
framexleftmargin=2pt,belowskip=9pt,aboveskip=9pt,%belowskip=-4pt,%
language=XML,basicstyle=\ttfamily\fontsize{8}{9}\selectfont,commentstyle=\bfseries\lst@ifdisplaystyle\color{red}\fi,%
stringstyle=\bfseries\lst@ifdisplaystyle\color{ForestGreen}\fi,showstringspaces=false,%frame=none,
string=[b]",morekeywords={[2]
%
description,
%
network,nodes,node,links,link,act,
%
networkChangeEvent,link,freespeed,
%
param,
%
population,person,plan,act,leg,route,
%
facilities,facility,activity,
%
vehicleDefinitions,vehicleType,vehicle,length,capacity,seats,standingRoom,
%
transitSchedule,
transitStops,stopFacility,
transitLine,transitRoute,transportMode,routeProfile,departures,departure,stop,
%
counts,count,volume,
%
config,module,param,parameterset,
%
roadpricing,cost,
%
},alsoletter={=}}}{}


\lstnewenvironment{xmlnine}{\lstset{%
%
backgroundcolor=\color{shadecolor},
%
frame=single,rulecolor=\color{shadecolor},framesep=2pt,xrightmargin=2pt,xleftmargin=2pt,framexrightmargin=2pt,%
framexleftmargin=2pt,belowskip=9pt,aboveskip=9pt,%belowskip=-4pt,%
language=XML,basicstyle=\ttfamily\footnotesize,commentstyle=\bfseries\lst@ifdisplaystyle\color{red}\fi,%
stringstyle=\bfseries\lst@ifdisplaystyle\color{ForestGreen}\fi,showstringspaces=false,%frame=none,
string=[b]",morekeywords={[2]
%
description,
%
network,nodes,node,links,link,act,
%
networkChangeEvent,link,freespeed,
%
param,
%
population,person,plan,act,leg,route,
%
facilities,facility,activity,
%
vehicleDefinitions,vehicleType,vehicle,length,capacity,seats,standingRoom,
%
transitSchedule, transitStops,stopFacility,
transitLine,transitRoute,transportMode,routeProfile,departures,departure,stop,
%
counts,count,volume,
%
config,module,param,parameterset,
%
roadpricing,cost,
%
},alsoletter={=}}}{}
%
% the "alsoletter={=}" seems to prevent that something like length="sldkfj"
% gets colored like an element
\makeatother

\makeatletter
\lstnewenvironment{shell}{\lstset{%
%
backgroundcolor=\color{shadecolor},
%
%belowskip=-4pt,%
language=bash,basicstyle=\ttfamily\fontsize{8}{9}\selectfont,lineskip=0pt,aboveskip=9pt,belowskip=9pt, frame=single,%
rulecolor=\color{shadecolor},%xrightmargin=4pt,xleftmargin=4pt%
xrightmargin=3pt,xleftmargin=3pt,framexrightmargin=-1pt,framexleftmargin=-1pt,
}} \makeatother

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\hyphenation{MATSim} % Word split: unknown words for latex. show how to split them.
\setcounter{tocdepth}{0}

\def\orange{\color{orange}}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newcommand{\mytitle}{The Multi-Agent Transport Simulation MATSim}
\newcommand{\myyear}{2015}
\newcommand{\karen}[1]{{\color{red} [\textbf{ke}: #1]}}
\newcommand{\ah}[1]{{\color{blue} [\textbf{ah}: #1]}}
\newcommand{\editdone}[1]{{\color{red} [\textbf{Edit done}: #1]}}
\renewcommand{\editdone}[1]{\relax}
\newcommand{\kwaah}[1]{{\color{ForestGreen} [\textbf{kwa}: #1]}}
\newcommand{\gunnar}[1]{{\color{blue} [\textbf{gf}: #1]}}
\newcommand{\benjamin}[1]{{\color{red} [\textbf{bk}: #1]}}
\newcommand{\michaz}[1]{{\color{green} [\textbf{michaz}: #1]}}
\newcommand{\joschka}[1]{{\color{red} [\textbf{jb}: #1]}}
\newcommand{\kai}[1]{{\color{orange} [\textbf{kn}: #1]}}  % we still need \kai{} to make it compiling
\newcommand{\thibaut}[1]{{\color{BrickRed} [\textbf{td}: #1]}}
\newcommand{\dobi}[1]{{\color{blue} [\textbf{cd}: #1]}}
\newcommand{\marcel}[1]{{\color{BrickRed} [\textbf{mr}: #1]}}
\newcommand{\mm}[1]{\color{blue} [\textbf{mm}: #1] \color{black}}
\newcommand{\mnote}[1]{\medskip\centerline{{\sf\footnotesize\color{blue}\hfill #1}}\vspace{-.8em}}

\newcommand{\who}[1]{\color{red} \textit{[#1]} \color{black}}
%\newcommand{\todo}[1]{\color{ForestGreen} \textit{[TODO: #1]} \color{black}}
\newcommand{\copied}[1]{\color{ForestGreen} \textit{[copied: #1]} \color{black}}

%%\newcommand{\chkAtEnd}{{\color{gray} [check status before going to print]}}

\newcommand*{\eg}{e.g.,~}
\newcommand*{\ie}{i.e.,~}
\newcommand*{\cf}{cf.~}

\newcommand{\MyEqRef}[1]{Equation~(\ref{#1})}
\newcommand{\note}[1]{\hl{[#1]}}
\newcommand{\Note}[1]{\note{#1}}
\renewcommand{\gunnar}[1]{\note{Gunnar: #1}}
\newcommand{\Gunnar}[1]{\gunnar{#1}}

%\newcommand{\corr}[2]{\st{#1} \ul{#2}}
\newcommand{\corr}[2]{#2}

%\newtheorem{proposition}{Proposition}
%\newtheorem{definition}{Definition}
\newcommand{\qedsymbol}{$\blacksquare$}

\newcommand{\cleardoublepageempty}{
 \begingroup
  \pagestyle{empty}
  \cleardoublepage
 \endgroup
}

\makeatletter
\renewcommand*{\cleardoublepage}{\clearpage\if@twoside \ifodd\c@page\else
\hbox{}%
\thispagestyle{empty}%
\newpage%
\if@twocolumn\hbox{}\newpage\fi\fi\fi}
\makeatother



% no widow sentences below figures etc.
\usepackage[all]{nowidow}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\usepackage{algorithm}
\usepackage[noend]{algpseudocode}
\makeatletter
\renewcommand\thealgorithm{\arabic{algorithm}}
\@addtoreset{algorithm}{chapter}
\makeatother
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%\usepackage{ulem}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\def\vec#1{\boldsymbol{\mathbf{#1}}}
\def\imp#1{\textbf{#1}}
\def\eps{\varepsilon}
\def\matsimorg{\url{http://matsim.org}}
\def\javadoc{\url{http://matsim.org/javadoc}}
\def\extensions{\url{http://matsim.org/extensions}}
\def\faq{\url{http://matsim.org/faq}}
\def\issuetracker{\url{http://matsim.org/issuetracker}}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% use hyper-refs for URL's and citations
\usepackage[bookmarks=false,breaklinks]{hyperref}
\usepackage{bookmark}
%% line breaks for URL's
\usepackage{url}
\hypersetup{bookmarksdepth=3}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% inserting subpart level.  Related to subpart definition earlier, but as
% far as I can see it needs to be called fairly late or it is overwritten
% by something else (probably the hyperref package). kai, dec'15

\makeatletter
\def\toclevel@part{-2}
\def\toclevel@subpart{-1}


\lstset{language=Java}


\if@namebib
\usepackage[round,sectionbib]{../Styles/natbib}
%\usepackage{chapterbib}
%\usepackage[comma,sort&compress,square]{natbib}
\renewcommand\@biblabel[1]{}
\renewenvironment{thebibliography}[1]
     {\section*{\refname}%
      \@mkboth{\refname}{\refname}%
      \list{}%
           {\settowidth\labelwidth{\@biblabel{#1}}
           \leftmargin\labelwidth
           \advance\leftmargin15.5pt\labelsep=4pt\itemindent-15.5pt
            \@openbib@code
            \usecounter{enumiv}}%
      \sloppy
      \clubpenalty4000
      \@clubpenalty \clubpenalty
      \widowpenalty4000%
      \sfcode`\.\@m}
     {\def\@noitemerr
       {\@latex@warning{Empty `thebibliography' environment}}%
      \endlist}
\else


\usepackage[numbers,sort&compress,comma,square]{natbib}

\renewcommand{\@biblabel}[1]{[#1]\hfill}
\def\refname{Bibliography}
\renewenvironment{thebibliography}[1]
     {\section*{\refname}%
      \@mkboth{\refname}{\refname}%
      \list{}%
           {\settowidth\labelwidth{\@biblabel{#1}}
                      \leftmargin\labelwidth
           \if@namebib\advance\leftmargin15.5pt\labelsep=4pt\itemindent-15.5pt\else\advance\leftmargin13.5pt\labelsep=13pt\itemindent0pt\itemsep6pt\fi
            \@openbib@code
            \usecounter{enumiv}}%
      \sloppy
      \clubpenalty4000
      \@clubpenalty \clubpenalty
      \widowpenalty4000%
      \sfcode`\.\@m}
     {\def\@noitemerr
       {\@latex@warning{Empty `thebibliography' environment}}%
      \endlist}
%\def\thebibliography#1{\chapter*{\refname}%
%\@mkboth{{\refname}}{{\refname}}%
%\list
%   {}{\settowidth\labelwidth{[#1]}
%   \leftmargin\labelwidth
%   \advance\leftmargin\labelsep
%%   \advance\leftmargin\bibindent
% %  \itemindent -\bibindent
%   \listparindent \itemindent
%   \parsep \z@
%   \itemsep3pt
%   \usecounter{enumiv}}
%   \def\newblock{}
%   \sloppy
%   \sfcode`\.=1000\relax}

\fi

\AtBeginDocument{\def\refname{Literatur}}


%\newenvironment{thechapbibliography}[1]
%     {\section*{\refname}%
%      \@mkboth{\refname}{\refname}%
%      \list{}%
%           {\settowidth\labelwidth{\@biblabel{#1}}
%           \leftmargin\labelwidth
%           \if@namebib\advance\leftmargin15.5pt\labelsep=4pt\itemindent-15.5pt\else\fi
%            \@openbib@code
%            \usecounter{enumiv}}%
%      \sloppy
%      \clubpenalty4000
%      \@clubpenalty \clubpenalty
%      \widowpenalty4000%
%      \sfcode`\.\@m}
%     {\def\@noitemerr
%       {\@latex@warning{Empty `thebibliography' environment}}%
%      \endlist}

\def\hang{\par\hangindent=5mm\hangafter=1\noindent}%

\newcommand\tablenames{Tabelle}
\def\fnum@table{\tablenames\nobreakspace\thesection.\thetable:}

\newcommand\figurenames{Abbildung}
\def\fnum@figure{\figurenames~\thesection.\thefigure:}

\def\figurecaptionfont{\fontsize{8bp}{11bp}\selectfont}
\def\tablecaptionfont{\fontsize{8bp}{11bp}\selectfont}

%\long\def\@makecaption#1#2{%
%\vskip2pt%
%%  \vskip\abovecaptionskip
%  \sbox\@tempboxa{{\figurecaptionfont#1}\hspace*{3pt}{\figurecaptionfont#2}}%
%  \ifdim \wd\@tempboxa >\hsize
%%   \hangafter=1\hangindent=8pt {\bfseries\selectfont#1}\hspace*{3pt}#2\par
%    {\figurecaptionfont{\@hangfrom{#1\hspace*{3pt}}#2}}\par
%  \else
%    \global \@minipagefalse
%    \hb@xt@\hsize{\hfill\box\@tempboxa\hfill}%
%  \fi
%  \vskip\belowcaptionskip}


\long\def\@makecaption#1#2{%
\vskip2pt%
%  \vskip\abovecaptionskip
  \sbox\@tempboxa{{\fontsize{8bp}{11bp}\selectfont#1\hspace*{3pt}#2}}%
  \ifdim \wd\@tempboxa >\hsize
%   \hangafter=1\hangindent=8pt {\bfseries\selectfont#1}\hspace*{3pt}#2\par
   \footnotesize \@hangfrom{#1\hspace*{3pt}}{#2}\par
  \else
    \global \@minipagefalse
    \hb@xt@\hsize{\hfill\box\@tempboxa\hfill}%
  \fi
  \vskip\belowcaptionskip}


\long\def\@tablecaption#1#2{%
\vskip2pt%
%  \vskip\abovecaptionskip
  \sbox\@tempboxa{{\fontsize{8bp}{11bp}\selectfont#1\hspace*{3pt}#2}}%
  \ifdim \wd\@tempboxa >\hsize
%   \hangafter=1\hangindent=8pt {\bfseries\selectfont#1}\hspace*{3pt}#2\par
   \footnotesize \@hangfrom{#1\hspace*{3pt}}{#2}\par
  \else
    \global \@minipagefalse
    \hb@xt@\hsize{\hfill\box\@tempboxa\hfill}%
  \fi
  \vskip10pt}


\renewcommand \thesubpart {\Alphee{part}}

\newcounter{tocsubpart}
\def\thetocsubpart{\Roman{tocsubpart}}
\def\thetocsubpart{\Alphtoc{tocsubpart}}
\def\Alphtoc#1{\@Alphtoc{\@nameuse{c@#1}}}

\def\@Alphtoc#1{\ifcase#1\or One \or Two\or Three\or Four\else\@Ialphtoc{#1}\fi}
\def\@Ialphtoc#1{\ifcase#1\or \or \or \or \or Five\or Six\or Seven\or Eight\or Nine\or Ten\or
   Eleven\or Twelve\or Thirteen\or Fourteen\or Fifteen\or Sixteen\or Seventeen\or Eighteen\or Nineteen\or %
   Twenty\or Twenty One\or Twenty Two\or Twenty Three\or Twenty Four\or Twenty Five\or
   Twenty Six\or Twenty Seven\or Twenty Eight\or Twenty Nine\else\@ctrerr\fi}

\def\Alphee#1{\@Alphee{\@nameuse{c@#1}}}

\def\@Alphee#1{\ifcase#1\or ONE\or TWO\or THREE\or FOUR\else\@Ialphee{#1}\fi}
\def\@Ialphee#1{\ifcase#1\or \or \or \or \or FIVE\or SIX\or SEVEN\or EIGHT\or NINE\or TEN\or
   ELEVEN\or TWELVE\or THIRTEEN\or FOURTEEN\or FIFTEEN\or SIXTEEN\or SEVENTEEN\or EIGHTEEN\or NINETEEN\or %
   TWENTY\or TWENTY ONE\or TWENTY TWO\or TWENTY THREE\or TWENTY FOUR\or TWENTY FIVE\or
   TWENTY SIX\or TWENTY SEVEN\or TWENTY EIGHT\or TWENTY NINE\else\@ctrerr\fi}


\renewcommand{\ThisCenterWallPaper}[2]{%
\AddToShipoutPicture*{\put(\LenToUnit{\wpXoffset},\LenToUnit{\wpYoffset}){%
     \parbox[b][\paperheight]{\paperwidth}{\vspace*{2.2pc}%
       \vfill
       \centering
       \hspace*{10pt}\includegraphics[width=#1\paperwidth,height=#1\paperheight,%
                        keepaspectratio]{#2}       \hspace*{-1pt}%
       \vfill
       \vspace*{-2.2pc}
     }}}
}

\def\subpartsubtitle#1{\gdef\@subpartsubtitle{#1}}
\subpartsubtitle{}

\def\@makesubparthead#1{\addtocounter{part}{-1}
  \vspace*{8\p@}%
  \colorbox{white}{%
    \parbox[b]{\textwidth}{%
      \ifnum \c@secnumdepth >\m@ne \hspace*{-9.5pt}\centerline{\partNumFont{S\hspace*{1pt}U\hspace*{1pt}%
      B\hspace*{1pt}P\hspace*{1pt}A\hspace*{1pt}R\hspace*{1pt}T\hspace*{3pt} \thesubpart}} \fi%
    }%
  }%

  \colorbox{white}{%%
    \parbox[b]{\textwidth}{\vspace*{92pt}%
    \hspace*{-9.5pt}\centerline{\partFont{\expandafter{#1}}}\par%
}%
  }%
    \vskip2pc
   \ifx\@subpartsubtitle\@empty\else\parbox[b]{\textwidth}{\centering\fontsize{20}{22}\selectfont\@subpartsubtitle}\fi%
\addtocounter{part}{1} \clearemptydoublepage}


\def\subpart{%
   \thispagestyle{empty}
   \global\@topnum\z@
   \@afterindenttrue
   % \let\\\relax
   \secdef\@subpart\@spart}

\def\@subpart[#1]#2{
  \markboth{}{}
  \ifnum \c@secnumdepth >\m@ne
    \refstepcounter{part}
    \addcontentsline{toc}{subpart}{\protect\numberline{\thesubpart:}#1}
  \else
    \addcontentsline{toc}{subpart}{#1}
  \fi
  \addtocontents{lof}{\protect\addvspace{5\p@}}
  \addtocontents{lot}{\protect\addvspace{5\p@}}
  \@makesubparthead{#2}
  \@afterheading
}


\newcommand\tocchapter{\if@openright\clearemptydoublepage\else\clearpage\fi
                    \thispagestyle{plain}%
                    \global\@topnum\z@
%                    \@afterindentfalse
                    \@afterindenttrue
                    \secdef\@tocchapter\@tocschapter}

\def\@tocchapter#1{\if@twocolumn
                   \@topnewpage[\@tocmakechapterhead{#1}]%
                 \else
                   \@tocmakechapterhead{#1}%
                   \@afterheading
                 \fi}

\def\@tocschapter#1{\if@twocolumn
                   \@topnewpage[\@tocmakeschapterhead{#1}]%
                 \else
                   \@tocmakeschapterhead{#1}%
                   \@afterheading
                 \fi}

\def\@tocmakeschapterhead#1{\markboth{#1}{#1}%
%\vspace*{63pt}%
\vspace*{0pt}%
  {\parindent \z@ %\centering%\raggedright
    \normalfont
    \interlinepenalty\@M
   \thispagestyle{plainch} {\bfseries\fontsize{20bp}{24bp}\selectfont#1}\par\nobreak
    \vskip 13.6pt
    %\vskip 169.2pt
    %\addcontentsline{toc}{fmchapter}{#1}
  }  \@afterindentfalse
  \@afterheading
}

\def\@tocmakechapterhead#1{\markboth{#1}{#1}%
\vspace*{63pt}%
  {\parindent \z@ \centering%\raggedright
    \normalfont
    \interlinepenalty\@M
   \thispagestyle{empty} \fontsize{18}{20}\selectfont   #1\par\nobreak
    \vskip 13.6pt
    \addcontentsline{toc}{fmchapter}{#1}
  }  \@afterindentfalse
  \@afterheading
}

\renewcommand*\l@part[2]{%
\def\numberline##1{\hb@xt@\@tempdima{{##1}\hfil}}
  \ifnum \c@tocdepth >-2\relax
    \addpenalty{-\@highpenalty}%
    \addvspace{14pt}%
    \setlength\@tempdima{40pt}%
    \begingroup
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      {\leavevmode
       \fontsize{12}{14}\selectfont #1\hfil \hb@xt@\@pnumwidth{\hss\fontsize{12}{14}\selectfont #2}}\par
       \nobreak
         \global\@nobreaktrue
         \everypar{\global\@nobreakfalse\everypar{}}%
    \endgroup
  \fi\vspace*{4pt}}

\def\@indexdottedtocline#1#2#3#4#5{%
  \renewcommand\@dotsep{1}
  \ifnum #1>\c@tocdepth \else
    \vskip5pt
    {\leftskip #2\relax \rightskip \@tocrmarg \parfillskip -\rightskip
     \parindent #2\relax\@afterindenttrue
     \interlinepenalty\@M
     \leavevmode
     \@tempdima #3\relax
     \advance\leftskip \@tempdima \null\nobreak\hskip -\leftskip
     {\fontsize{11}{13}\selectfont#4}\nobreak
     \leaders\hbox{}\hfill
     \nobreak
     \hb@xt@\@pnumwidth{\hfil\fontsize{11}{13}\selectfont#5}%
     \par}%
  \fi\vskip2pt}

\newcommand*\l@backchapter[2]{%
  \ifnum \c@tocdepth >\m@ne
    \addpenalty{-\@highpenalty}%
    \vskip5.1pt% \@plus\p@
    \setlength\@tempdima{1.5em}%
    \begingroup
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      \leavevmode \selectfont
      \advance\leftskip\@tempdima
      \hskip -\leftskip
     \fontsize{11}{13}\selectfont #1\nobreak\hfil \nobreak\hb@xt@\@pnumwidth{\hss #2}\par
      \penalty\@highpenalty
    \endgroup
  \fi\vskip 2pt}


{\renewcommand\lstinline[1][]{\fontsize{9}{13}\selectfont%
    \leavevmode\bgroup % \hbox\bgroup --> \bgroup
      \def\lst@boxpos{b}%
      \lsthk@PreSet\lstset{flexiblecolumns,#1}%
      \lsthk@TextStyle
      \@ifnextchar\bgroup{%
        \ifnum`{=0}\fi%
        \afterassignment\lst@InlineG \let\@let@token}%
                         \lstinline@}}

\def\UrlFont{\tt\footnotesize}

\newcommand{\footnoteurl}[1]{{\fontsize{7}{9}\selectfont\url{#1}}}

%%%longtable font
\captionsetup[longtable]{singlelinecheck=off,labelfont={sf,bf},font={sf,normalfont},justification=raggedright}


\def\ps@dtheading{% for special running head
      \let\@oddfoot\@empty\let\@evenfoot\@empty
      \def\@evenhead{\fontsize{9}{11}\fontfamily{\rmdefault}\selectfont{{\thepage}}\hspace*{9.7pt}%
      The Multi-Agent Transport Simulation MATSim\hfil}%
      \def\@oddhead{\hfill\fontsize{9}{11}\fontfamily{\rmdefault}\selectfont{\leftmark}\hspace*{9.7pt}{{\thepage}}}%
      \let\@mkboth\markboth
    \def\chaptermark##1{%
      \markboth{\ifnum \c@secnumdepth >\m@ne
          %\if@mainmatter
          %{%
%          {\@chapapp\ \thechapter}}\hspace*{1em}%
%          \fi
        \fi
        ##1}{}}%
    \def\sectionmark##1{%
    \markright {%\MakeUppercase
    {%
%        \ifnum \c@secnumdepth >\z@
%          {\thesection}\hspace*{6pt}%
%        \fi
\@booktitle        %##1
        }}}}

\hypersetup{colorlinks=false,pdfborder={0 0 0}}
\makeatother

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%\input{acronyms}
%\input{glossary}

\def\figsource#1{\vspace*{4pt}\par\fontsize{8}{10}\selectfont\textit{Source}: #1}
\def\adjspace#1#2{\spaceskip#1pt plus1.2pt minus1.2pt#2}

\usepackage[]{glossaries}
\renewcommand*{\acronymtype}{acronym}
\newglossary[alg]{acronym}{acr}{acn}{Acronyms}
\newglossaryentry{Adenine}{name=\ensuremath{x}, description={x is a variable, just kidding}, sort=x}
%\makeglossaries

\makeatletter
%%%%%%% boxed text
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\usepackage[most]{tcolorbox}

\def\boxenumerate{%
    \@ifnextchar[{\@boxnumerate}{\@boxnumerate[0.]}}

\def\@boxnumerate[#1]{%
     \ifnum \@enumdepth >3 \@toodeep\else
     \advance\@enumdepth \@ne
     \edef\@enumctr{enum\romannumeral\the\@enumdepth}
     \list{\csname label\@enumctr\endcsname}{%
          \leftmargini   16.5pt
          \topsep     8.1pt
          \itemsep       3pt
          \parsep        \z@
          \labelsep      7pt
          \rightmargin   \z@
           \listparindent 0pt%\parindent
           \itemindent    \z@
       \setlength{\leftmargin}{\csname leftmargin\romannumeral\the\@enumdepth\endcsname}
       \usecounter{\@enumctr}
       \settowidth\labelwidth{#1}
       \addtolength{\leftmargin}{\labelwidth}
       \addtolength{\leftmargin}{\labelsep}
              \addtolength{\leftmargin}{-16pt}
       \def\makelabel##1{\hss\llap{##1}}}%
     \fi
   }
\let\endboxenumerate\endlist


\def\boxitemize{%
   \@ifnextchar[{\@boxitemize}{\@boxitemize[$\bullet$]}}

\def\@boxitemize[#1]{%
     \ifnum \@itemdepth >3 \@toodeep\else
     \advance\@itemdepth \@ne
     \edef\@itemctr{item\romannumeral\the\@itemdepth}
     \list{\csname label\@itemctr\endcsname}{%
          \leftmargini   0\p@
   \addtolength\leftmargini{-.6mm}
   \topsep     8.1pt
   \itemsep       .1pt
   \parsep        \z@
   \labelsep      0.5em
   \rightmargin   \z@
   \listparindent \parindent
   \itemindent    \z@
       \setlength{\leftmargin}{\csname leftmargin\romannumeral\the\@itemdepth\endcsname}
       \settowidth\labelwidth{#1}
       \addtolength{\leftmargin}{\labelwidth}
       \addtolength{\leftmargin}{\labelsep}
       \addtolength{\leftmargin}{5.15pt}
       \def\makelabel##1{\hss \llap{##1\hskip1pt}}}%
     \fi
   }
\let\endboxitemize\endlist


\def\boxsection#1{{\par\addvspace{1pc}\fontsize{11}{13}\fontseries{b}\selectfont#1\par\addvspace{9pt}}}
\def\boxsubsection#1{{\par\addvspace{6pt}\fontsize{10}{13}\fontshape{it}\selectfont#1\par\addvspace{6pt}}}

\newenvironment{boxedtext}[1][]{\tcbset{width=\textwidth,
                  %%enhanced,
                  %%frame hidden,
                  boxsep=0pt,
                  left=18pt,
                  right=18pt,
                  top=15pt,
                  bottom=15pt,
                  boxrule=1pt,
                  colback=white,
                  arc=0pt,
                  outer arc=0mm,
                  colframe=black,
                  colbacktitle=white,
                  coltitle=black,
                  titlerule=0pt,
                  toptitle=13pt,
                  fonttitle=\fontsize{12}{14}\fontseries{b}\selectfont}
                  \par\addvspace{1pc}\begin{tcolorbox}[breakable,title=#1]%%
}{\end{tcolorbox}}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%% extract
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\def\extracthead#1{\par\addvspace{6pt}\fontsize{9}{11}\selectfont#1\par\addvspace{3pt}}
\def\extractauthor#1{\par\addvspace{0pt}\fontsize{9}{11}\selectfont(#1)\par\addvspace{3pt}}
\newenvironment{extract}
               {\par%
                \list{}{\labelwidth=0pt\leftmargin=2pc\fontsize{9}{11}\selectfont%
                \partopsep0pt%
                \rightmargin2pc
                \parsep=\z@
                }%
                   \item\relax}
               {\endlist\addvspace{-2pt}}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% figure caption as per the figure width
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\newbox\figbox%
\newdimen\figwidth%

\if@floatasperwidth
\def\processfigure#1#2{\bgroup\parindent\z@%
\setbox\figbox=\hbox{#1}%
\figwidth\wd\figbox%
\ifdim\figwidth < \textwidth%
\setbox4=\hbox to \textwidth{\vbox{\centering\begin{minipage}{\figwidth}\noindent #1\par \parbox{\figwidth}{#2}\end{minipage}}}\box4
\else
\setbox4=\hbox to \textwidth{\vbox{\begin{minipage}{\figwidth}\noindent #1\par \parbox{\figwidth}{#2}\end{minipage}}}\box4
\fi
%%\centering\noindent#1\par #2
\egroup%
}
\else
\def\processfigure#1#2{\bgroup #1#2
\egroup%
}
\fi%

\newbox\figurebox
\newdimen\figurewidth

\def\figureasperwidth#1#2{\bgroup\parindent\z@%
\setbox\figurebox=\hbox{#1}%
\figurewidth\wd\figurebox%
\ifdim\figurewidth<\textwidth%
\setbox4=\hbox to \textwidth{\vbox{\centering\begin{minipage}{\figurewidth}\noindent #1\par #2\end{minipage}}}\box4
\else
\setbox4=\hbox to \textwidth{\vbox{\begin{minipage}{\figurewidth}\noindent #1\par \parbox{\figurewidth}{#2}\end{minipage}}}\box4
\fi
%%%\centering\noindent#1\par #2
\egroup%
}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%% poem style
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\usepackage{../Styles/up-verse}

\newcommand{\attrib}[1]{%
\nopagebreak{\footnotesize #1\par\addvspace{12pt}}}
\renewcommand{\poemtitlefont}{\normalfont\large\itshape}

%%%%%MCLX
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newenvironment{MCLX}[1][]{\begin{multicols}{#1}}{\end{multicols}}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\if@endnoteexist
\usepackage{endnotes}
\let\footnote\endnote
\else
\def\theendnotes{\relax}
\fi


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% Abbreviations
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newenvironment{abbreviations}[1][72pt]
               {\chapter*{Abbreviations}\list{}{\settowidth{\labelwidth}{#1}%
                        \labelsep=12pt%
                        \leftmargin\labelwidth%
                        \advance\leftmargin\labelsep%
                        \def\makelabel##1{\rlap{##1}}
                        }}
               {\endlist}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% Chronology
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newenvironment{chronology}[1][72pt]
               {\chapter*{Chronology}\list{}{\settowidth{\labelwidth}{#1}%
                        \labelsep=12pt%
                        \leftmargin\labelwidth%
                        \advance\leftmargin\labelsep%
                        \def\makelabel##1{\rlap{##1}}
                        }}
               {\endlist}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% Glossary
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newenvironment{glossaries}[1][72pt]
               {\chapter*{Glossary}\list{}{\settowidth{\labelwidth}{#1}%
                        \labelsep=12pt%
                        \leftmargin\labelwidth%
                        \itemsep4pt%
                        \advance\leftmargin\labelsep%
                        \def\makelabel##1{\rlap{##1}}
                        }}
               {\endlist}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


\newcommand{\headingfont}{\sffamily\bfseries}




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% CHAPTER HEADER STYLING


\newcommand{\chptNumFont}{\fontsize{76}{80}\headingfont}
\newcommand{\chptFont}{\Huge\bfseries\headingfont}

\newlength{\chptTitleWidth}
\newlength{\chptPadding}
\newlength{\chptNoPos}

\setlength{\chptPadding}{10pt}         % Space between gray box border and text
\setlength{\chptTitleWidth}{\textwidth}
\addtolength{\chptTitleWidth}{-2\chptPadding}



\newif\ifeauthor
\eauthortrue

\newif\ifeaddress
\eaddresstrue

\newif\if@eauthor@provided \@eauthor@providedfalse
\newif\if@eaddress@provided \@eaddress@providedfalse

\def\eauthor#1{\gdef\@eauthor{\centerline{\parbox{\textwidth}{\fontsize{14}{16}\selectfont#1}}}\global\@eauthor@providedtrue}
\def\eaddress#1{\gdef\@eaddress{\parbox{\textwidth}{\centering\fontsize{10}{12}\selectfont{#1}\par}}\global\@eaddress@providedtrue}

\newcommand\@chapapps{\chapternames}
\newcommand\chapternames{C\hspace*{1pt}H\hspace*{1pt}A\hspace*{1pt}P\hspace*{1pt}T\hspace*{1pt}E\hspace*{1pt}R\hspace*{2pt}}


\def\openpageauthor#1{\gdef\@openpageauthor{#1}}
\openpageauthor{Author Names}


\def\doinumber#1{\gdef\@doinumber{#1}}
\doinumber{Doi Numbers}

\def\ps@plainch{%
\def\@oddfoot{\hbox to \textwidth{\hfill\foliostyle\thepage\hspace*{1.8pt}}}
\def\@evenfoot{\hbox to \textwidth{\hspace*{-1.8pt}\foliostyle\thepage\hfill}}
\let\@oddhead\relax \let\@evenhead\relax}%


\def\chapsubtitle#1{\gdef\@chapsubtitle{\fontsize{12}{14}\selectfont#1}}
\chapsubtitle{}

\def\@makechapterhead#1{%
  \vspace*{9pt}%
  {%\parindent 0pt% \raggedright
  \normalfont
    \ifnum \c@secnumdepth >\m@ne
      \if@mainmatter
%       \thispagestyle{plainch} \centerline{\fontsize{12}{14}\fontfamily{\rmdefault}\selectfont\@chapapps\space \thechapter}
%        \par\nobreak
%        \vskip 41.2\p@%
      \fi
    \fi
    \interlinepenalty\@M
       \thispagestyle{plainch} \centerline{\fontsize{12}{14}\fontfamily{\rmdefault}\selectfont\@chapapps\space \thechapter}
    \fontsize{18}{20}\selectfont\centering #1\vphantom{g}\par\nobreak
    \vskip 13\p@
    \ifx\@chapsubtitle\@empty\else\@chapsubtitle\par\addvspace{1pc}\fi
  \enlargethispage{-55pt}}
\vbox to 137.9pt{\if@eauthor@provided%
\vskip0\p@
\@eauthor\par%
\else%
\vskip0\p@%
\fi%
\if@eaddress@provided%
\vspace*{2.6pt}%
\@eaddress\par%
\else
\vskip0\p@
\fi\vfill}%
}

\def\@makeschapterhead#1{\markboth{#1}{#1}%
\vspace*{3pt}%
  {\parindent \z@ %\centering%\raggedright
    \normalfont
    \interlinepenalty\@M
   \thispagestyle{plainch} {\bfseries\fontsize{20bp}{24bp}\selectfont#1}\par\nobreak
   \vskip11pt
  }  \@afterindentfalse
  \@afterheading
    %\addcontentsline{toc}{fmchapter}{#1}
}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% PART PAGE STYLING
%\fontfamily{pfu}\fontseries{b}

%\newcommand{\partNumFont}{\fontsize{18}{20}\selectfont}
\newcommand{\partNumFont}{\fontsize{18}{20}\fontfamily{\rmdefault}\selectfont}
\newcommand{\partFont}{\fontsize{24}{26}\selectfont}

\def\@makeparthead#1{
  \vspace*{8\p@}%
    \parbox[b]{\textwidth}{%
      \ifnum \c@secnumdepth >\m@ne {\hspace*{-15.5pt}\colorbox{white}{
      \partNumFont{P\hspace*{1pt}A\hspace*{1pt}R\hspace*{1pt}T\hspace*{3pt} \thepart}}} \fi%
  }%

  %%
    \parbox[b]{\textwidth}{\vspace*{39pt}\hspace*{-18pt}%
    {\colorbox{white}{\partFont{\expandafter{\hskip5pt#1\hskip5pt\vphantom{$^{\fontsize{15}{16}\selectfont1^{\ast}}$}}}}}\par%
  }%
 }

\def\@makesparthead#1{
  \vspace*{50\p@}%
  \colorbox{white}{%
    \parbox[b]{\textwidth}{%
    \partFont{\expandafter{#1}}\par%
    }%
  }%

 }

\def\part{%
   \thispagestyle{empty}
   \global\@topnum\z@
   \@afterindenttrue
   % \let\\\relax
   \secdef\@part\@spart}

\def\@part[#1]#2{
  \markboth{}{}
  \ifnum \c@secnumdepth >\m@ne
    \refstepcounter{part}
    \addcontentsline{toc}{part}{\protect\numberline{Part \thepart:}#1}
  \else
    \addcontentsline{toc}{part}{#1}
  \fi
  \addtocontents{lof}{\protect\addvspace{5\p@}}
  \addtocontents{lot}{\protect\addvspace{5\p@}}
  \@makeparthead{#2}
  \@afterheading
}

\def\@spart#1{\@makesparthead{#1}\@afterheading}


\newcommand{\partsubtiltefont}{\fontsize{11}{11}\fontseries{it}\selectfont\leftskip-4pt}
\newcommand{\partepigraphfont}{\fontsize{9}{13}\fontseries{it}\selectfont\leftskip-9pt}
\newcommand{\partepisourcefont}{\fontsize{9}{13}\fontseries{it}\selectfont\leftskip-9pt}

\def\partsubtitle#1{\gdef\@partsubtitle{#1}}
\partsubtitle{}
\def\partepigraph#1{\gdef\@partepigraph{#1}}
\partepigraph{}
\def\partepisource#1{\gdef\@partepisource{#1}}
\partepisource{}

\def\partattrib#1{\gdef\@partattrib{#1}}
\partattrib{}
\newenvironment{partaltverse}%
{\fontsize{9}{13}\selectfont\leftskip-1.5pc\starpatternfalse\patternfalse\setcounter{vslineno}{1}}%
{\altindentfalse\ifx\@partattrib\@empty\else\noindent\vskip-8pt{---\@partattrib}\par\addvspace{7.6pc}\fi}


\newcommand\makeparttitle{\par
  \begingroup
     \ifx\@partsubtitle\@empty\else\par\addvspace{1pc}{\partsubtiltefont\hskip-8pt\@partsubtitle}\par\addvspace{1pc}\fi
     \ifx\@partepigraph\@empty\else\par\addvspace{1pc}\parbox{236pt}{\partepigraphfont\@partepigraph}\par\addvspace{1pc}\fi
     \ifx\@partepisource\@empty\else\par\addvspace{-5.6pt}\parbox{236pt}{\partepisourcefont---\@partepisource}\par\addvspace{1pc}\fi
     \thispagestyle{plain}
  \endgroup
}



\newcolumntype{L}[1]{>{\raggedright\let\newline\\\arraybackslash\hspace{0pt}\hangindent8pt}m{#1}}

\def\ln{\qopname\relax o{\textrm{ln}}}

\renewcommand{\clearemptydoublepage}{\newpage{\pagestyle{empty}\cleardoublepage}}

%%%%%%% FM Elements

\def\halftitle#1{%
\vspace*{121.1pt}%
\thispagestyle{empty}\parbox{\textwidth}
{\centering\fontsize{30}{32}\selectfont#1\par}
\vskip24pt}

\def\halftitlesubtitle#1{%
\thispagestyle{empty}\parbox{\textwidth}
{\centering\fontsize{20}{24}\selectfont#1\par}
\vskip92pt\clearpage}

\def\dedication#1{\if@openright\clearemptydoublepage\else\clearpage\fi%
\vspace*{37.1pt}%
\thispagestyle{empty}\parbox{\textwidth}
{\centering\fontsize{9}{11}\fontshape{it}\selectfont#1\par}
\vskip92pt\clearpage}

\newenvironment{subvention}{\if@openright\clearemptydoublepage\else\clearpage\fi\vspace*{32\p@}%
\centering\begin{minipage}{237pt}\thispagestyle{empty}\fontsize{9}{11}\selectfont\centering}{\end{minipage}\clearpage}

\def\seriestitle#1{{\fontsize{10}{10}\selectfont#1\vspace*{3pt}}}
\def\serieseditor#1{{\vspace*{6pt}\fontsize{8}{8}\selectfont#1\vspace*{3pt}}}


\newenvironment{seriespage}{%
\clearpage\noindent\begin{minipage}{\textwidth}\thispagestyle{empty}\fontsize{8}{10}\selectfont%
%
}{\end{minipage}\clearpage}


\def\journaltitle#1{\if@openright\clearemptydoublepage\else\clearpage\fi%
\vspace*{21.1pt}%
\thispagestyle{empty}\parbox{\textwidth}
{\centering\fontsize{30}{32}\selectfont#1\par}
\vskip22pt}

\def\journalsubtitle#1{%
%\vspace*{21.1pt}%
\thispagestyle{empty}\parbox{\textwidth}
{\centering\fontsize{14}{17}\selectfont\itshape#1}
\vskip92pt}


\def\editedby#1{
\vspace*{0pt}
{\centering\fontsize{18}{20}\selectfont Edited by\\[2pt] #1\par}
\vspace*{30pt}}

\def\editedaff#1{
\vspace*{0pt}
\parbox{\textwidth}{\centering\fontsize{9}{12}\selectfont\itshape #1\par}
\vspace*{30pt}}

\newenvironment{copyrightline}
               {\clearpage\thispagestyle{empty}\vspace*{8pt}\centering}
               {}

\renewcommand*\l@fmchapter[2]{%
  \ifnum \c@tocdepth >\m@ne
    \addpenalty{-\@highpenalty}%
    % \@plus\p@
    \setlength\@tempdima{1.5em}%
    \begingroup
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      \leavevmode %\bfseries
      \advance\leftskip\@tempdima
      \hskip -\leftskip
     \fontsize{11}{13}\fontseries{b}\selectfont #1\nobreak\hfil \nobreak\hb@xt@\@pnumwidth{\hss #2}\par
      \penalty\@highpenalty
    \endgroup
  \fi\vskip 4pt}

\newcommand*\l@bmchapter[2]{%
  \ifnum \c@tocdepth >\m@ne
    \addpenalty{-\@highpenalty}%
    % \@plus\p@
    \setlength\@tempdima{8.5em}%
    \begingroup
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      \leavevmode %\bfseries
      \advance\leftskip\@tempdima
      \hskip -\leftskip
     \fontsize{11}{13}\fontseries{b}\selectfont #1\nobreak\hfil \nobreak\hb@xt@\@pnumwidth{\hss #2}\par
      \penalty\@highpenalty
    \endgroup
  \fi\vskip 4pt}


\newcommand*\l@fmIntro[2]{%
  \ifnum \c@tocdepth >\m@ne
    \addpenalty{-\@highpenalty}%
    \vskip3pt% \@plus\p@
    \setlength\@tempdima{1.5em}%
    \begingroup
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      \leavevmode \selectfont
      \advance\leftskip\@tempdima
      \hskip -\leftskip
     \fontsize{11}{13}\selectfont #1\nobreak\hfil \nobreak\hb@xt@\@pnumwidth{\hss #2}\par
      \penalty\@highpenalty
    \endgroup
  \fi\vskip 4pt}

\renewcommand*\l@part[2]{%
\def\numberline##1{\hb@xt@\@tempdima{{##1}\hfil}}
  \ifnum \c@tocdepth >-2\relax
    \addpenalty{-\@highpenalty}%
    \addvspace{14pt}%
    \setlength\@tempdima{35pt}%
    \begingroup
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      {\leavevmode
       \fontsize{12}{14}\selectfont #1\hfil \hb@xt@\@pnumwidth{\hss\fontsize{11}{14}\selectfont #2}}\par
       \nobreak
         \global\@nobreaktrue
         \everypar{\global\@nobreakfalse\everypar{}}%
    \endgroup
  \fi\vspace*{4pt}}


\renewcommand*\l@chapter[2]{%
\def\numberline##1{\hb@xt@\@tempdima{{##1}\hfil}}
  \ifnum \c@tocdepth >-2\relax
    \addpenalty{-\@highpenalty}%
    \addvspace{8pt}%
    \setlength\@tempdima{10pt}%
    \begingroup
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      {\leavevmode
       \fontsize{10bp}{14bp}\bfseries\selectfont #1\hfil
       \leaders\hbox{$\m@th \mkern \@dotsep mu\hbox{.}\mkern \@dotsep
        mu$}\hfill \nobreak\hb@xt@\@pnumwidth{\hss\bfseries#2}}
       \par
       \nobreak
         \global\@nobreaktrue
         \everypar{\global\@nobreakfalse\everypar{}}%
    \endgroup
  \fi\vspace*{-19pt}}

\def\@dottedtocline#1#2#3#4#5{%
  \renewcommand\@dotsep{1}
  \ifnum #1>\c@tocdepth \else
    \vskip \z@
    {\leftskip #2\relax \rightskip \@tocrmarg \parfillskip -\rightskip
     \parindent #2\relax\@afterindenttrue
     \interlinepenalty\@M
     \leavevmode
     \@tempdima #3\relax
     \advance\leftskip \@tempdima \null\nobreak\hskip -\leftskip
     {#4}\nobreak
     \leaders\hbox{}\hfill
     \nobreak
     \hb@xt@\@pnumwidth{\hfil#5}%
     \par}%
  \fi\vskip2pt}

\renewcommand*\l@section{\@dottedtocline{1}{2mm}{2.3em}}

\def\@indexdottedtocline#1#2#3#4#5{%
  \renewcommand\@dotsep{1}
  \ifnum #1>\c@tocdepth \else
    \vskip1.5pt
    {\leftskip #2\relax \rightskip \@tocrmarg \parfillskip -\rightskip
     \parindent #2\relax\@afterindenttrue
     \interlinepenalty\@M
     \leavevmode
     \@tempdima #3\relax
     \advance\leftskip \@tempdima \null\nobreak\hskip -\leftskip
     {#4}\nobreak
     \leaders\hbox{}\hfill
     \nobreak
     \hb@xt@\@pnumwidth{\hfil#5}%
     \par}%
  \fi\vskip2pt}

\newcommand*\l@index{\@indexdottedtocline{1}{0pt}{2.3em}}


\renewcommand*\l@backchapter[2]{%
  \ifnum \c@tocdepth >\m@ne
    \addpenalty{-\@highpenalty}%
    \vskip3pt% \@plus\p@
    \setlength\@tempdima{1.5em}%
    \begingroup
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      \leavevmode \selectfont
      \advance\leftskip\@tempdima
      \hskip -\leftskip
     \fontsize{11}{13}\selectfont #1\nobreak\hfil \nobreak\hb@xt@\@pnumwidth{\hss #2}\par
      \penalty\@highpenalty
    \endgroup
  \fi\vskip 4pt}

\makeatother


%%% Chap epigraph
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\def\chepisource#1{\gdef\@chepisource{#1}}
\chepisource{}

\newenvironment{chepigraph}
               {\null\hfill\begin{minipage}{245pt}\vspace*{-70pt}\flushleft\itshape}
               {\ifx\@chepisource\@empty\else\vskip2pt\hfill---{\rm\@chepisource}\fi\end{minipage}\par\addvspace{24pt}}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% table automation
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\makeatletter
\newif\if@rotate \@rotatefalse
\newif\if@rotatecenter \@rotatecenterfalse
\def\rotatecenter{\global\@rotatecentertrue}
\def\rotateendcenter{\global\@rotatecenterfalse}
\def\rotate{\global\@rotatetrue}
\def\endrotate{\global\@rotatefalse}
\newdimen\rotdimen
\def\rotstart#1{\special{ps: gsave currentpoint currentpoint translate
    #1 neg exch neg exch translate}}
\def\rotfinish{\special{ps: currentpoint grestore moveto}}
\def\rotl#1{\rotdimen=\ht#1\advance\rotdimen by \dp#1
    \hbox to \rotdimen{\vbox to\wd#1{\vskip \wd#1
    \rotstart{270 rotate}\box #1\vss}\hss}\rotfinish}
\def\rotr#1{\rotdimen=\ht #1\advance\rotdimen by \dp#1
    \hbox to \rotdimen{\vbox to \wd#1{\vskip \wd#1
    \rotstart{90 rotate}\box #1\vss}\hss}\rotfinish}

\newdimen\tempdime
\newbox\temptbox

\newlength{\tabbotskip}%
\setlength{\tabbotskip}{0pt}%

\newcommand{\processtable}[3]{\centering\setbox\temptbox=\hbox{{\fontsize{10bp}{14bp}\selectfont#2}}%
\tempdime\wd\temptbox\@processtable{#1}{#2}{#3}{\tempdime}}
{\relax}

\newcommand{\unprocesstable}[3]{\centering\setbox\temptbox=\hbox{{\fontsize{10bp}{14bp}\selectfont#2}}%
\tempdime\wd\temptbox\@processtable{#1}{#2}{#3}{\tempdime}}
{\relax}

\newcommand{\@processtable}[4]{%
\if@rotate
\setbox4=\vbox to \textwidth{\vss\hbox to \textheight{\hss%
\begin{minipage}{#4}%
\fontsize{10bp}{14bp}\selectfont%
{#1}{#2}%
\vskip1pt\noindent
\parbox{#4}{\fontsize{10bp}{14bp}\selectfont\raggedright #3\par}%
\end{minipage}}\vss}%
\else
\setbox4=\hbox to \textwidth{\vbox{\begin{minipage}[t]{#4}%
\fontsize{10bp}{14bp}\selectfont%
{#1}{#2}%
\vskip2.5pt\noindent
\parbox{#4}{\fontsize{10bp}{14bp}\selectfont #3\vphantom{y}\par}%
\if!#3!\setlength{\tabbotskip}{-19\p@}\else\setlength{\tabbotskip}{-9.3\p@}\fi%
%\vspace*{\tabbotskip}%
\end{minipage}}}%
\fi
\if@rotate\rotl{4}\else\box4\fi}
{\relax}


\newcounter{example}
\def\theexample{\arabic{example}}
%%%%% Example environment
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\DeclareFloatingEnvironment[fileext=frm,placement={!ht},name=Frame]{myfloat}
\newenvironment{Example}[2][]
    {\def\fnum@figure{Example~\theexample:}
    \addtocounter{example}{1}
    \begin{figure}[#1]
    \centering
    {#2}
    }
    {\end{figure}%
    \def\fnum@figure{\figurenames~\thefigure:}%
}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% create empty boxes for figures
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\def\figbox#1#2{\fcolorbox{gray}{gray}{\parbox{#1}{\vspace*{#2}\hspace*{0pc}}}}


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newenvironment{preface}[1][]{\if@openright\cleardoublepage\fi\ifx!#1!\chapter*{preface}\else\chapter*{#1}\fi
\pagestyle{fmheadings}
\markboth{Vorwort}{Vorwort}
\def\author##1{\par\addvspace{24pt}\noindent\itshape{##1}}%
\def\address##1{\par\addvspace{2pt}\noindent\fontsize{8bp}{10bp}\itshape\selectfont{##1}}%
}{\clearpage}
\def\prefacehead#1{{\par\normalsize\itshape#1\par\addvspace{3pt}}}
\def\prefaceeditor#1{{\par\addvspace{6pt}\begin{flushright}\normalsize#1\end{flushright}}}

\def\ORN#1{\par\addvspace{4pt}\noindent\textbullet\hskip6pt\textbullet\hskip6pt\textbullet\hskip6pt\par\addvspace{7pt}%
\noindent #1\par\addvspace{4pt}}

\newenvironment{contentspage}[1][]{\if@openright\cleardoublepage\fi
\def\contentsname{Inhaltsverzeichnis}
\pagestyle{fmheadings}
\ifx!#1!\chapter*{\contentsname}\else\chapter*{#1}\fi
\markboth{\contentsname}{\contentsname}}{\clearpage}


%%%% letter definitions
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\def\letterdate#1{\gdef\@letterdate{#1}}
\letterdate{On Board U.S.S. Louisiana, Nov. 14.}

\def\letterto#1{\gdef\@letterto{#1}}
\letterto{Dear Ted:}

\def\letterfrom#1{\gdef\@letterfrom{#1}}
\letterfrom{Your Father}

\newenvironment{letter}{\ifx\@letterdate\@empty\else\hfill\@letterdate\fi\par\addvspace{1pc}
\ifx\@letterto\@empty\else\noindent\@letterto\fi\par\addvspace{1pc}\@afterindenttrue
\hsize\textwidth\flushleft\setlength{\parindent}{1pc}
}{\par\vskip0pt\ifx\@letterfrom\@empty\else\hfill\@letterfrom\fi\par\addvspace{1pc}
}

\def\letterdate#1{}

\newenvironment{abouttheauthors}[1][]{\ifx!#1!\chapter*{About the Authors}\else\chapter*{#1}\fi}{}

\def\appendixtitle#1{\chapter*{Appendix\break #1}}

\newenvironment{symbols}[1][]{\ifx!#1!\chapter*{Symbols}\else\chapter*{#1}\fi}{}

\newenvironment{acknowledgements}[1][]{\ifx!#1!\chapter*{Acknowledgements}\else\chapter*{#1}\fi}{}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\RequirePackage{authorindex}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% set double space for manuscript

\if@setdblsapce
\RequirePackage{setspace}
\linespread{2}
\fi
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% contributors
\newenvironment{contributors}{\setlength{\parindent}{0pt}\chapter*{Contributors}\begin{multicols}{2}\columnsep=1pc}{\end{multicols}}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% QandA
\newenvironment{QandA}{\removelastskip\par\addvspace{1pc}\setlength{\parindent}{0pt}\begin{enumerate}}%
{\end{enumerate}\par\addvspace{1pc}\removelastskip}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newcommand{\createphoto}[6]{%
\begin{wrapfigure}[#1]{#2}{#3}
#4
  \begin{center}
    #5
    \vskip-6pt
  \end{center}
  {{\fontsize{8}{10}\selectfont Photo Credit:#6}}
\end{wrapfigure}}

%%%%% Theorem like environments
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newtheorem{theorem}{Theorem}
\renewcommand\thetheorem{\arabic{theorem}}
\newtheorem{corollary}[theorem]{Corollary}
\newtheorem{definition}[theorem]{Definition}
\newtheorem{lemma}[theorem]{Lemma}
\newtheorem{notation}[theorem]{Notation}
\newtheorem{problem}[theorem]{Problem}
\newtheorem{proposition}[theorem]{Proposition}
\newtheorem{summary}[theorem]{Summary}
\newenvironment{proof}{\vskip0pt\noindent \textbf{Proof:} }{ \hfill $\Box$}
\newenvironment{example}{\vskip6pt\noindent \textbf{Example:} }{ }
\newenvironment{remark}{\vskip6pt\noindent \textbf{Remark:}\itshape }{ }
\newenvironment{solution}{\vskip6pt\noindent \textbf{Solution:}\itshape }{ }
\makeatother
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


\endinput
%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% End of file `Ubiquity-7x10.cls'.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
